/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.slider;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.slider.ActionBarSliderContent;
import com.socialize.ui.slider.ActionBarSliderHandle;
import com.socialize.ui.slider.ActionBarSliderItem;
import com.socialize.ui.slider.OnActionBarSliderMoveListener;
import com.socialize.ui.slider.SliderAnimationSet;
import com.socialize.util.DisplayUtils;
import com.socialize.view.BaseView;
import java.util.Map;
import java.util.TreeMap;

public class ActionBarSliderView
extends BaseView {
    private DisplayUtils displayUtils;
    private IBeanFactory<SliderAnimationSet> sliderAnimationSetFactory;
    private IBeanFactory<ActionBarSliderContent> actionBarSliderContentFactory;
    private IBeanFactory<ActionBarSliderHandle> actionBarSliderHandleFactory;
    private Map<String, SliderAnimationSet> animations;
    private SliderAnimationSet currentAnimationSet;
    private SocializeLogger logger;
    private int[] parentViewlocation;
    private ActionBarSliderHandle handle;
    private ActionBarSliderContent content;
    private DisplayState displayState = DisplayState.CLOSE;
    private int handleHeight = 30;
    private int actionBarTop;
    private int actionBarHeight;
    private int deviceHeight;
    private int peekHeight;
    private boolean moving = false;
    private ActionBarSliderItem currentItem;
    public OnActionBarSliderMoveListener onActionBarSliderMoveListener;

    public ActionBarSliderView(Context context) {
        super(context);
    }

    public ActionBarSliderView(Context context, int[] parentLocation, int peekHeight) {
        super(context);
        this.parentViewlocation = parentLocation;
        this.peekHeight = peekHeight;
    }

    public void init() {
        this.deviceHeight = this.displayUtils.getDisplayHeight();
        this.actionBarHeight = this.displayUtils.getDIP(44);
        this.animations = new TreeMap<String, SliderAnimationSet>();
        this.actionBarTop = this.peekHeight > 0 ? this.peekHeight : (this.parentViewlocation != null ? this.parentViewlocation[1] : this.deviceHeight - this.actionBarHeight);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setOrientation(1);
        this.handleHeight = this.displayUtils.getDIP(this.handleHeight);
        this.content = (ActionBarSliderContent)((Object)this.actionBarSliderContentFactory.getBean(new Object[]{this, this.deviceHeight - this.handleHeight}));
        this.handle = (ActionBarSliderHandle)((Object)this.actionBarSliderHandleFactory.getBean(new Object[]{this, this.handleHeight}));
        this.addView((View)this.handle);
        this.addView((View)this.content);
    }

    public void clearContent() {
        if (this.currentItem != null) {
            this.currentItem.onClear(this);
        }
    }

    public void updateContent() {
        if (this.currentItem != null) {
            this.currentItem.onUpdate(this);
        }
    }

    public boolean showLastItem() {
        if (this.currentItem != null) {
            this.showSliderItem(this.currentItem);
            return true;
        }
        return false;
    }

    public synchronized void loadItem(ActionBarSliderItem item) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Loading slider item for " + item.getId());
        }
        if (this.currentItem != item) {
            this.currentItem = item;
            this.content.removeAllViews();
            this.content.addView(item.getView());
            this.handle.setTitle(item.getTitle());
            this.handle.setIconImage(item.getIconImage());
            this.currentAnimationSet = this.animations.get(item.getId());
            if (this.currentAnimationSet == null) {
                this.currentAnimationSet = (SliderAnimationSet)this.sliderAnimationSetFactory.getBean();
                this.currentAnimationSet.init(item, this);
                this.animations.put(item.getId(), this.currentAnimationSet);
            }
            this.currentItem.onCreate(this);
        }
    }

    public void showSliderItem(ActionBarSliderItem item) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Showing slider item for " + item.getId());
        }
        if (this.content != null && item != null) {
            DisplayState state = item.getStartPosition();
            if (item != this.currentItem) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Don't have item [" + item.getId() + "], current state is " + (Object)((Object)this.displayState));
                }
                this.close();
                this.loadItem(item);
                switch (state) {
                    case PEEK: {
                        this.peek();
                        break;
                    }
                    case MAXIMIZE: {
                        this.maximize();
                    }
                }
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Already have item [" + item.getId() + "], current state is " + (Object)((Object)this.displayState));
                }
                if (!this.displayState.equals((Object)state)) {
                    switch (state) {
                        case PEEK: {
                            this.peek();
                            break;
                        }
                        case MAXIMIZE: {
                            this.maximize();
                        }
                    }
                }
            }
        }
    }

    public void addContentItem(View child) {
        if (this.content != null) {
            this.content.addView(child);
        }
    }

    public void setHandleText(String text) {
        this.handle.setTitle(text);
    }

    public void maximize() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("maximize called in state " + (Object)((Object)this.displayState));
        }
        switch (this.displayState) {
            case CLOSE: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getMaximizeFromClose(), DisplayState.MAXIMIZE);
                break;
            }
            case PEEK: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getMaximizeFromPeek(), DisplayState.MAXIMIZE);
            }
        }
    }

    protected void startAnimationForState(Animation animation, DisplayState state) {
        this.setVisibility(0);
        this.clearAnimation();
        this.displayState = state;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("starting animation for state " + (Object)((Object)state));
        }
        this.startAnimation(animation);
    }

    public void peek() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("peek called in state " + (Object)((Object)this.displayState));
        }
        switch (this.displayState) {
            case CLOSE: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getPeekFromClose(), DisplayState.PEEK);
                break;
            }
            case MAXIMIZE: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getPeekFromMaximize(), DisplayState.PEEK);
            }
        }
    }

    public void close() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("close called in state " + (Object)((Object)this.displayState));
        }
        switch (this.displayState) {
            case MAXIMIZE: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getCloseFromMaximized(), DisplayState.CLOSE);
                break;
            }
            case PEEK: {
                this.startAnimationForState((Animation)this.currentAnimationSet.getCloseFromPeek(), DisplayState.CLOSE);
            }
        }
        this.displayState = DisplayState.CLOSE;
    }

    public void onClose() {
        if (this.currentItem != null) {
            this.currentItem.onClose(this);
        }
        if (this.onActionBarSliderMoveListener != null) {
            this.onActionBarSliderMoveListener.onClose(this);
        }
    }

    public void onOpen() {
        if (this.currentItem != null) {
            this.currentItem.onOpen(this);
        }
        if (this.onActionBarSliderMoveListener != null) {
            this.onActionBarSliderMoveListener.onOpen(this);
        }
    }

    public void slide() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("slide called in state " + (Object)((Object)this.displayState));
        }
        if (!this.moving) {
            this.moving = true;
            switch (this.displayState) {
                case CLOSE: {
                    this.peek();
                    break;
                }
                case PEEK: {
                    this.maximize();
                    break;
                }
                case MAXIMIZE: {
                    if (this.currentItem.isPeekOnClose()) {
                        this.peek();
                        break;
                    }
                    this.close();
                }
            }
        }
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public int[] getParentViewlocation() {
        return this.parentViewlocation;
    }

    public void setParentViewlocation(int[] parentViewlocation) {
        this.parentViewlocation = parentViewlocation;
    }

    public void setSliderAnimationSetFactory(IBeanFactory<SliderAnimationSet> sliderAnimationSetFactory) {
        this.sliderAnimationSetFactory = sliderAnimationSetFactory;
    }

    public void setActionBarSliderContentFactory(IBeanFactory<ActionBarSliderContent> actionBarSliderContentFactory) {
        this.actionBarSliderContentFactory = actionBarSliderContentFactory;
    }

    public void setActionBarSliderHandleFactory(IBeanFactory<ActionBarSliderHandle> actionBarSliderHandleFactory) {
        this.actionBarSliderHandleFactory = actionBarSliderHandleFactory;
    }

    protected boolean isMoving() {
        return this.moving;
    }

    protected void setMoving(boolean moving) {
        this.moving = moving;
    }

    protected ActionBarSliderHandle getHandle() {
        return this.handle;
    }

    protected ActionBarSliderContent getContent() {
        return this.content;
    }

    public DisplayState getDisplayState() {
        return this.displayState;
    }

    protected int getHandleHeight() {
        return this.handleHeight;
    }

    protected int getActionBarTop() {
        return this.actionBarTop;
    }

    protected int getActionBarHeight() {
        return this.actionBarHeight;
    }

    protected int getDeviceHeight() {
        return this.deviceHeight;
    }

    public static enum DisplayState {
        CLOSE,
        MAXIMIZE,
        PEEK;

    }
}

