/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.share;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.socialize.ShareUtils;
import com.socialize.SocializeService;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.share.SimpleShareListener;
import com.socialize.auth.AuthProviderType;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.entity.Share;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.share.ShareAddListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.facebook.FacebookShareCell;
import com.socialize.networks.twitter.TwitterShareCell;
import com.socialize.ui.dialog.DialogPanelView;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.ui.share.EmailCell;
import com.socialize.ui.share.GooglePlusCell;
import com.socialize.ui.share.RememberCell;
import com.socialize.ui.share.SMSCell;
import com.socialize.ui.share.ShareDialogListener;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.ClickableSectionCell;
import com.socialize.ui.view.SocializeButton;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import org.json.JSONObject;

public class SharePanelView
extends DialogPanelView {
    private ShareDialogListener shareDialogListener;
    private SocialNetworkListener socialNetworkListener;
    private Colors colors;
    private SocializeConfig config;
    private SocializeButton continueButton;
    private SocializeButton cancelButton;
    private TextView otherOptions;
    private LinearLayout buttonLayout;
    private int displayOptions = 111;
    private Entity entity;
    private IBeanFactory<FacebookShareCell> facebookShareCellFactory;
    private IBeanFactory<TwitterShareCell> twitterShareCellFactory;
    private IBeanFactory<GooglePlusCell> googlePlusCellFactory;
    private IBeanFactory<EmailCell> emailCellFactory;
    private IBeanFactory<SMSCell> smsCellFactory;
    private IBeanFactory<RememberCell> rememberCellFactory;
    private Drawables drawables;
    private DisplayUtils displayUtils;
    private FacebookShareCell facebookShareCell;
    private TwitterShareCell twitterShareCell;
    private EmailCell emailCell;
    private SMSCell smsCell;
    private RememberCell rememberCell;
    private GooglePlusCell googlePlusCell;
    private LocalizationService localizationService;
    float radii = 6.0f;
    int padding = 8;
    int headerHeight = 45;
    float headerRadius = 3.0f;
    private float[] fbRadii = new float[]{this.radii, this.radii, this.radii, this.radii, 0.0f, 0.0f, 0.0f, 0.0f};
    private int[] fbStroke = new int[]{1, 1, 0, 1};
    private float[] twRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.radii, this.radii, this.radii, this.radii};
    private int[] twStroke = new int[]{1, 1, 1, 1};

    public SharePanelView(Context context) {
        super(context);
    }

    public void init() {
        LinearLayout.LayoutParams contentParams;
        boolean landscape = false;
        if (this.displayUtils != null) {
            this.padding = this.displayUtils.getDIP(12);
            this.headerRadius = this.displayUtils.getDIP(3);
            this.headerHeight = this.displayUtils.getDIP(45);
            this.radii = this.displayUtils.getDIP(this.radii);
            landscape = this.displayUtils.isLandscape();
            this.fbRadii = new float[]{this.radii, this.radii, this.radii, this.radii, 0.0f, 0.0f, 0.0f, 0.0f};
            this.twRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.radii, this.radii, this.radii, this.radii};
        }
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, -1);
        masterParams.gravity = 49;
        this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        this.setOrientation(1);
        RelativeLayout container = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-1, -1);
        containerParams.gravity = 49;
        containerParams.weight = 1.0f;
        container.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.makeShareButtons();
        View continueButtonLayout = this.makeButtons();
        View header = this.makeHeaderView(this.headerHeight, this.headerRadius);
        LinearLayout contentLayout = new LinearLayout(this.getContext());
        contentLayout.setPadding(this.padding, this.padding, this.padding, 0);
        contentLayout.setGravity(49);
        if (landscape) {
            contentParams = new LinearLayout.LayoutParams(-1, -2);
            contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        } else {
            contentParams = new RelativeLayout.LayoutParams(-1, -2);
            contentParams.addRule(13);
            contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        }
        LinearLayout.LayoutParams socialNetworkButtonParams = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout.LayoutParams emailSMSButtonParams = new LinearLayout.LayoutParams(-1, -2);
        emailSMSButtonParams.setMargins(0, this.padding, 0, 0);
        contentLayout.setOrientation(1);
        LinearLayout socialNetworkButtonLayout = new LinearLayout(this.getContext());
        socialNetworkButtonLayout.setPadding(0, 0, 0, 0);
        socialNetworkButtonLayout.setOrientation(1);
        socialNetworkButtonLayout.setLayoutParams((ViewGroup.LayoutParams)socialNetworkButtonParams);
        LinearLayout emailSMSButtonLayout = new LinearLayout(this.getContext());
        emailSMSButtonLayout.setPadding(0, 0, 0, 0);
        emailSMSButtonLayout.setOrientation(1);
        emailSMSButtonLayout.setLayoutParams((ViewGroup.LayoutParams)emailSMSButtonParams);
        if (this.facebookShareCell != null || this.twitterShareCell != null) {
            ClickableSectionCell.OnToggleListener onToggleListener = new ClickableSectionCell.OnToggleListener(){

                @Override
                public void onToggle(boolean on) {
                    boolean twOK;
                    boolean fbOK = SharePanelView.this.facebookShareCell != null && SharePanelView.this.facebookShareCell.isToggled();
                    boolean bl = twOK = SharePanelView.this.twitterShareCell != null && SharePanelView.this.twitterShareCell.isToggled();
                    if (fbOK || twOK) {
                        if (SharePanelView.this.rememberCell != null) {
                            SharePanelView.this.rememberCell.setVisibility(0);
                        }
                        SharePanelView.this.continueButton.setEnabled(true);
                    } else {
                        if (SharePanelView.this.rememberCell != null) {
                            SharePanelView.this.rememberCell.setVisibility(8);
                        }
                        SharePanelView.this.continueButton.setEnabled((SharePanelView.this.displayOptions & 0x80) != 0);
                    }
                }
            };
            if (this.facebookShareCell != null) {
                socialNetworkButtonLayout.addView((View)this.facebookShareCell);
                this.facebookShareCell.setOnToggleListener(onToggleListener);
            }
            if (this.twitterShareCell != null) {
                socialNetworkButtonLayout.addView((View)this.twitterShareCell);
                this.twitterShareCell.setOnToggleListener(onToggleListener);
            }
            contentLayout.addView((View)socialNetworkButtonLayout);
        }
        if (this.googlePlusCell != null) {
            LinearLayout googlePlusCellLayout = new LinearLayout(this.getContext());
            googlePlusCellLayout.setPadding(0, 0, 0, 0);
            googlePlusCellLayout.setLayoutParams((ViewGroup.LayoutParams)emailSMSButtonParams);
            googlePlusCellLayout.addView((View)this.googlePlusCell);
            contentLayout.addView((View)googlePlusCellLayout);
        }
        if (this.emailCell != null || this.smsCell != null) {
            if (this.emailCell != null) {
                emailSMSButtonLayout.addView((View)this.emailCell);
            }
            if (this.smsCell != null) {
                emailSMSButtonLayout.addView((View)this.smsCell);
            }
            contentLayout.addView((View)emailSMSButtonLayout);
        }
        if (this.rememberCell != null) {
            contentLayout.addView((View)this.rememberCell);
        }
        LinearLayout.LayoutParams skipAuthParams = new LinearLayout.LayoutParams(-1, -2);
        skipAuthParams.gravity = 81;
        skipAuthParams.weight = 1.0f;
        if (this.displayUtils != null) {
            skipAuthParams.setMargins(0, this.displayUtils.getDIP(10), 0, 0);
        }
        this.otherOptions = new TextView(this.getContext());
        if (this.localizationService != null) {
            this.otherOptions.setText((CharSequence)this.localizationService.getString("socialize_share_more_options"));
        }
        this.otherOptions.setTextSize(1, 12.0f);
        if (this.colors != null) {
            this.otherOptions.setTextColor(this.colors.getColor("ANON_CELL_TITLE"));
        }
        this.otherOptions.setGravity(81);
        this.otherOptions.setPadding(0, 0, 0, this.padding);
        this.otherOptions.setLayoutParams((ViewGroup.LayoutParams)skipAuthParams);
        this.otherOptions.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final SafeProgressDialog progress = SafeProgressDialog.show(SharePanelView.this.getContext());
                ShareUtils.shareViaOther(SharePanelView.this.getActivity(), SharePanelView.this.entity, new ShareAddListener(){

                    @Override
                    public void onError(SocializeException error) {
                        progress.dismiss();
                        SharePanelView.this.showErrorToast(SharePanelView.this.getContext(), error);
                    }

                    @Override
                    public void onCreate(Share result) {
                        progress.dismiss();
                    }
                });
            }
        });
        contentLayout.addView((View)this.otherOptions);
        if (landscape) {
            RelativeLayout.LayoutParams scrollParams = new RelativeLayout.LayoutParams(-1, -1);
            scrollParams.setMargins(this.padding, this.padding, this.padding, 0);
            scrollParams.addRule(13);
            ScrollView scroller = new ScrollView(this.getContext());
            scroller.setLayoutParams((ViewGroup.LayoutParams)scrollParams);
            scroller.addView((View)contentLayout);
            container.addView((View)scroller);
        } else {
            container.addView((View)contentLayout);
        }
        this.addView(header);
        this.addView((View)container);
        this.addView(continueButtonLayout);
    }

    public void applyDisplayOptions() {
        if (this.otherOptions != null) {
            if ((this.displayOptions & 0x20) != 0) {
                this.otherOptions.setVisibility(0);
            } else {
                this.otherOptions.setVisibility(8);
            }
        }
        if (this.facebookShareCell != null) {
            if ((this.displayOptions & 4) != 0) {
                this.facebookShareCell.setVisibility(0);
            } else {
                this.facebookShareCell.setVisibility(8);
            }
        }
        if (this.twitterShareCell != null) {
            if ((this.displayOptions & 8) != 0) {
                this.twitterShareCell.setVisibility(0);
            } else {
                this.twitterShareCell.setVisibility(8);
            }
        }
        if (this.emailCell != null) {
            if ((this.displayOptions & 1) != 0) {
                this.emailCell.setVisibility(0);
            } else {
                this.emailCell.setVisibility(8);
            }
        }
        if (this.smsCell != null) {
            if ((this.displayOptions & 2) != 0) {
                this.smsCell.setVisibility(0);
            } else {
                this.smsCell.setVisibility(8);
            }
        }
        if (this.rememberCell != null) {
            if ((this.displayOptions & 0x10) != 0) {
                this.rememberCell.setVisibility(0);
            } else {
                this.rememberCell.setVisibility(8);
                this.rememberCell = null;
            }
        }
        if (this.googlePlusCell != null) {
            if ((this.displayOptions & 0x40) != 0) {
                this.googlePlusCell.setVisibility(0);
            } else {
                this.googlePlusCell.setVisibility(8);
            }
        }
        if (this.buttonLayout != null) {
            if ((this.displayOptions & 0x20) != 0) {
                this.buttonLayout.setPadding(this.padding, 0, this.padding, this.padding);
            } else {
                this.buttonLayout.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
    }

    protected void makeShareButtons() {
        boolean googlePlusOK;
        Context context;
        LinearLayout.LayoutParams cellParams = new LinearLayout.LayoutParams(-1, -2);
        SocializeService socialize = this.getSocialize();
        boolean fbOK = socialize.isSupported(context = this.getContext(), AuthProviderType.FACEBOOK) && this.facebookShareCellFactory != null;
        boolean twOK = socialize.isSupported(context, AuthProviderType.TWITTER) && this.twitterShareCellFactory != null;
        boolean emailOK = socialize.canShare(context, ShareType.EMAIL) && this.emailCellFactory != null;
        boolean smsOK = socialize.canShare(context, ShareType.SMS) && this.smsCellFactory != null;
        boolean rememberOk = this.rememberCellFactory != null;
        boolean bl = googlePlusOK = this.config != null && this.config.isGooglePlusEnabled() && socialize.canShare(context, ShareType.GOOGLE_PLUS) && this.googlePlusCellFactory != null;
        if (fbOK) {
            this.facebookShareCell = (FacebookShareCell)((Object)this.facebookShareCellFactory.getBean());
            if (this.facebookShareCell != null) {
                this.facebookShareCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.facebookShareCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                if (twOK) {
                    this.twitterShareCell = (TwitterShareCell)((Object)this.twitterShareCellFactory.getBean());
                    if (this.twitterShareCell != null) {
                        this.twitterShareCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                        this.twitterShareCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                        this.twitterShareCell.setBackgroundData(this.twRadii, this.twStroke, -16777216);
                    }
                    this.facebookShareCell.setBackgroundData(this.fbRadii, this.fbStroke, -16777216);
                }
            }
        } else if (twOK) {
            this.twitterShareCell = (TwitterShareCell)((Object)this.twitterShareCellFactory.getBean());
            if (this.twitterShareCell != null) {
                this.twitterShareCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.twitterShareCell.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
        if (googlePlusOK) {
            this.googlePlusCell = (GooglePlusCell)((Object)this.googlePlusCellFactory.getBean());
            if (this.googlePlusCell != null) {
                this.googlePlusCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
            }
        }
        if (emailOK) {
            this.emailCell = (EmailCell)((Object)this.emailCellFactory.getBean());
            if (this.emailCell != null) {
                this.emailCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.emailCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                if (smsOK) {
                    this.smsCell = (SMSCell)((Object)this.smsCellFactory.getBean());
                    this.smsCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                    this.smsCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                    this.emailCell.setBackgroundData(this.fbRadii, this.fbStroke, -16777216);
                    this.smsCell.setBackgroundData(this.twRadii, this.twStroke, -16777216);
                }
            }
        } else if (smsOK) {
            this.smsCell = (SMSCell)((Object)this.smsCellFactory.getBean());
            if (this.smsCell != null) {
                this.smsCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.smsCell.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
        if (rememberOk) {
            this.rememberCell = (RememberCell)((Object)this.rememberCellFactory.getBean());
            if (this.rememberCell != null) {
                LinearLayout.LayoutParams rememberCellParams = new LinearLayout.LayoutParams(-1, -2);
                rememberCellParams.setMargins(0, this.padding, 0, 0);
                this.rememberCell.setLayoutParams((ViewGroup.LayoutParams)rememberCellParams);
            }
        }
        if (this.facebookShareCell != null) {
            this.facebookShareCell.setAuthListener(this.getAuthClickListener(this.facebookShareCell, SocialNetwork.FACEBOOK));
        }
        if (this.twitterShareCell != null) {
            this.twitterShareCell.setAuthListener(this.getAuthClickListener(this.twitterShareCell, SocialNetwork.TWITTER));
        }
        if (this.emailCell != null) {
            this.emailCell.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    if (SharePanelView.this.shareDialogListener != null) {
                        SharePanelView.this.shareDialogListener.onSimpleShare(ShareType.EMAIL);
                    }
                    final SafeProgressDialog progress = SafeProgressDialog.show(v.getContext());
                    if (SharePanelView.this.dialog != null) {
                        SharePanelView.this.dialog.dismiss();
                    }
                    ShareUtils.shareViaEmail(SharePanelView.this.getActivity(), SharePanelView.this.entity, new SimpleShareListener(){

                        @Override
                        public void onError(SocializeException error) {
                            progress.dismiss();
                            SharePanelView.this.showErrorToast(v.getContext(), error);
                        }

                        @Override
                        public void onCreate(Share entity) {
                            progress.dismiss();
                        }

                        @Override
                        public boolean onBeforePost(Activity parent, SocialNetwork socialNetwork, PostData postData) {
                            return SharePanelView.this.socialNetworkListener != null && SharePanelView.this.socialNetworkListener.onBeforePost(parent, socialNetwork, postData);
                        }

                        @Override
                        public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                            if (SharePanelView.this.socialNetworkListener != null) {
                                SharePanelView.this.socialNetworkListener.onAfterPost(parent, socialNetwork, responseObject);
                            }
                        }
                    });
                }
            });
        }
        if (this.smsCell != null) {
            this.smsCell.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    if (SharePanelView.this.shareDialogListener != null) {
                        SharePanelView.this.shareDialogListener.onSimpleShare(ShareType.SMS);
                    }
                    if (SharePanelView.this.dialog != null) {
                        SharePanelView.this.dialog.dismiss();
                    }
                    final SafeProgressDialog progress = SafeProgressDialog.show(v.getContext());
                    ShareUtils.shareViaSMS(SharePanelView.this.getActivity(), SharePanelView.this.entity, new SimpleShareListener(){

                        @Override
                        public void onError(SocializeException error) {
                            progress.dismiss();
                            SharePanelView.this.showErrorToast(v.getContext(), error);
                        }

                        @Override
                        public void onCreate(Share entity) {
                            progress.dismiss();
                        }

                        @Override
                        public boolean onBeforePost(Activity parent, SocialNetwork socialNetwork, PostData postData) {
                            return SharePanelView.this.socialNetworkListener != null && SharePanelView.this.socialNetworkListener.onBeforePost(parent, socialNetwork, postData);
                        }

                        @Override
                        public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                            if (SharePanelView.this.socialNetworkListener != null) {
                                SharePanelView.this.socialNetworkListener.onAfterPost(parent, socialNetwork, responseObject);
                            }
                        }
                    });
                }
            });
        }
        if (this.googlePlusCell != null) {
            this.googlePlusCell.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    if (SharePanelView.this.shareDialogListener != null) {
                        SharePanelView.this.shareDialogListener.onSimpleShare(ShareType.GOOGLE_PLUS);
                    }
                    if (SharePanelView.this.dialog != null) {
                        SharePanelView.this.dialog.dismiss();
                    }
                    final SafeProgressDialog progress = SafeProgressDialog.show(v.getContext());
                    ShareUtils.shareViaGooglePlus(SharePanelView.this.getActivity(), SharePanelView.this.entity, new SimpleShareListener(){

                        @Override
                        public void onError(SocializeException error) {
                            progress.dismiss();
                            SharePanelView.this.showErrorToast(v.getContext(), error);
                        }

                        @Override
                        public void onCreate(Share entity) {
                            progress.dismiss();
                        }

                        @Override
                        public boolean onBeforePost(Activity parent, SocialNetwork socialNetwork, PostData postData) {
                            return SharePanelView.this.socialNetworkListener != null && SharePanelView.this.socialNetworkListener.onBeforePost(parent, socialNetwork, postData);
                        }

                        @Override
                        public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                            if (SharePanelView.this.socialNetworkListener != null) {
                                SharePanelView.this.socialNetworkListener.onAfterPost(parent, socialNetwork, responseObject);
                            }
                        }
                    });
                }
            });
        }
    }

    protected View makeButtons() {
        this.buttonLayout = new LinearLayout(this.getContext());
        if (this.continueButton != null) {
            LinearLayout.LayoutParams buttonParams = new LinearLayout.LayoutParams(-1, -2);
            this.buttonLayout.setPadding(this.padding, 0, this.padding, this.padding);
            this.buttonLayout.setOrientation(0);
            this.buttonLayout.setLayoutParams((ViewGroup.LayoutParams)buttonParams);
            this.buttonLayout.setGravity(17);
            this.continueButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SharePanelView.this.continueButton.setEnabled(false);
                    SocialNetwork[] networks = null;
                    if (SharePanelView.this.facebookShareCell != null && SharePanelView.this.facebookShareCell.isToggled()) {
                        networks = SharePanelView.this.twitterShareCell != null && SharePanelView.this.twitterShareCell.isToggled() ? new SocialNetwork[]{SocialNetwork.FACEBOOK, SocialNetwork.TWITTER} : new SocialNetwork[]{SocialNetwork.FACEBOOK};
                    } else if (SharePanelView.this.twitterShareCell != null && SharePanelView.this.twitterShareCell.isToggled()) {
                        networks = new SocialNetwork[]{SocialNetwork.TWITTER};
                    }
                    boolean remember = false;
                    if (SharePanelView.this.rememberCell != null) {
                        remember = SharePanelView.this.rememberCell.isToggled();
                    }
                    SharePanelView.this.shareDialogListener.onContinue(SharePanelView.this.dialog, remember, networks);
                }
            });
            if (this.cancelButton != null) {
                this.cancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SharePanelView.this.dialog.dismiss();
                        SharePanelView.this.shareDialogListener.onCancel(SharePanelView.this.dialog);
                    }
                });
                this.buttonLayout.addView((View)this.cancelButton);
            }
            this.buttonLayout.addView((View)this.continueButton);
        }
        return this.buttonLayout;
    }

    protected View makeShareBadge() {
        RelativeLayout.LayoutParams badgeParams = new RelativeLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams badgeLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        badgeLayoutParams.gravity = 17;
        badgeParams.addRule(13);
        RelativeLayout badgeLayout = new RelativeLayout(this.getContext());
        badgeLayout.setLayoutParams((ViewGroup.LayoutParams)badgeLayoutParams);
        if (this.drawables != null) {
            ImageView authBadge = new ImageView(this.getContext());
            authBadge.setImageDrawable(this.drawables.getDrawable("share_badge.png"));
            authBadge.setLayoutParams((ViewGroup.LayoutParams)badgeParams);
            authBadge.setPadding(0, 0, 0, this.padding);
            badgeLayout.addView((View)authBadge);
        }
        return badgeLayout;
    }

    protected View makeHeaderView(int headerHeight, float headerRadius) {
        LinearLayout.LayoutParams headerParams = new LinearLayout.LayoutParams(-1, headerHeight);
        TextView header = new TextView(this.getContext());
        if (this.colors != null) {
            GradientDrawable headerBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("AUTH_PANEL_BOTTOM"), this.colors.getColor("AUTH_PANEL_TOP")});
            headerBG.setCornerRadii(new float[]{headerRadius, headerRadius, headerRadius, headerRadius, 0.0f, 0.0f, 0.0f, 0.0f});
            CompatUtils.setBackgroundDrawable((View)header, (Drawable)headerBG);
        }
        if (this.localizationService != null) {
            header.setText((CharSequence)this.localizationService.getString("socialize_share_header"));
        }
        header.setTextSize(1, 18.0f);
        header.setTextColor(-1);
        header.setGravity(17);
        header.setLayoutParams((ViewGroup.LayoutParams)headerParams);
        return header;
    }

    public void updateNetworkButtonState() {
        if (this.facebookShareCell != null) {
            this.facebookShareCell.setToggled(this.getSocialize().isAuthenticatedForRead(AuthProviderType.FACEBOOK, new String[0]));
        }
        if (this.twitterShareCell != null) {
            this.twitterShareCell.setToggled(this.getSocialize().isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0]));
        }
    }

    public void checkSupportedNetworkButtonState() {
        if (this.facebookShareCell != null && this.facebookShareCell.isToggled()) {
            this.facebookShareCell.setToggled(this.getSocialize().isAuthenticatedForRead(AuthProviderType.FACEBOOK, new String[0]));
        }
        if (this.twitterShareCell != null && this.twitterShareCell.isToggled()) {
            this.twitterShareCell.setToggled(this.getSocialize().isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0]));
        }
    }

    public void setFacebookShareCellFactory(IBeanFactory<FacebookShareCell> facebookSignInCellFactory) {
        this.facebookShareCellFactory = facebookSignInCellFactory;
    }

    public void setTwitterShareCellFactory(IBeanFactory<TwitterShareCell> twitterSignInCellFactory) {
        this.twitterShareCellFactory = twitterSignInCellFactory;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public FacebookShareCell getFacebookShareCell() {
        return this.facebookShareCell;
    }

    public TwitterShareCell getTwitterShareCell() {
        return this.twitterShareCell;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setContinueButton(SocializeButton continueButton) {
        this.continueButton = continueButton;
    }

    public void setCancelButton(SocializeButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public void setShareDialogListener(ShareDialogListener shareDialogListener) {
        this.shareDialogListener = shareDialogListener;
    }

    public void setEmailCellFactory(IBeanFactory<EmailCell> emailCellFactory) {
        this.emailCellFactory = emailCellFactory;
    }

    public void setSmsCellFactory(IBeanFactory<SMSCell> smsCellFactory) {
        this.smsCellFactory = smsCellFactory;
    }

    public void setRememberCellFactory(IBeanFactory<RememberCell> rememberCellFactory) {
        this.rememberCellFactory = rememberCellFactory;
    }

    public void setGooglePlusCellFactory(IBeanFactory<GooglePlusCell> googlePlusCellFactory) {
        this.googlePlusCellFactory = googlePlusCellFactory;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setSocialNetworkListener(SocialNetworkListener socialNetworkListener) {
        this.socialNetworkListener = socialNetworkListener;
    }

    public void setDisplayOptions(int displayOptions) {
        this.displayOptions = displayOptions;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public SocializeButton getContinueButton() {
        return this.continueButton;
    }

    public SocializeButton getCancelButton() {
        return this.cancelButton;
    }

    protected SocializeAuthListener getAuthClickListener(final ClickableSectionCell cell, final SocialNetwork network) {
        return new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                SocializeLogger.e(error.getMessage(), error);
                SharePanelView.this.showErrorToast(SharePanelView.this.getContext(), error);
                if (SharePanelView.this.socialNetworkListener != null) {
                    SharePanelView.this.socialNetworkListener.onNetworkError(SharePanelView.this.getActivity(), network, error);
                }
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                cell.setToggled(true);
                SharePanelView.this.checkSupportedNetworkButtonState();
            }

            @Override
            public void onAuthFail(SocializeException error) {
                SocializeLogger.e(error.getMessage(), error);
                SharePanelView.this.showError(SharePanelView.this.getContext(), error);
                if (SharePanelView.this.socialNetworkListener != null) {
                    SharePanelView.this.socialNetworkListener.onNetworkError(SharePanelView.this.getActivity(), network, error);
                }
            }

            @Override
            public void onCancel() {
            }
        };
    }
}

