/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.header;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.i18n.LocalizationService;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;

public class SocializeHeader
extends LinearLayout {
    private TextView titleText;
    private ImageView titleImage;
    private DisplayUtils displayUtils;
    private Drawables drawables;
    private Colors colors;
    private LocalizationService localizationService;
    private String headerTextKey;
    private String headerText;

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public SocializeHeader(Context context) {
        super(context);
    }

    public TextView getTitleText() {
        return this.titleText;
    }

    public void setTitleText(TextView titleText) {
        this.titleText = titleText;
    }

    public void setText(String text) {
        this.titleText.setText((CharSequence)text);
    }

    public ImageView getTitleImage() {
        return this.titleImage;
    }

    public void setTitleImage(ImageView titleImage) {
        this.titleImage = titleImage;
    }

    public void init() {
        int four = this.displayUtils.getDIP(4);
        int eight = this.displayUtils.getDIP(8);
        int height = this.displayUtils.getDIP(57);
        LinearLayout.LayoutParams titlePanelLayoutParams = new LinearLayout.LayoutParams(-1, height);
        titlePanelLayoutParams.gravity = 16;
        this.setLayoutParams((ViewGroup.LayoutParams)titlePanelLayoutParams);
        this.setOrientation(0);
        this.setPadding(four, four, four, four);
        ColorDrawable background = new ColorDrawable(-16777216);
        Drawable headerBG = this.drawables.getDrawable("header.png", true, false, true);
        Drawable[] layers = new Drawable[]{background, headerBG};
        LayerDrawable bg = this.newLayerDrawable(layers);
        bg.setLayerInset(1, 0, 0, 0, 1);
        CompatUtils.setBackgroundDrawable((View)this, (Drawable)bg);
        this.titleText = new TextView(this.getContext());
        this.titleText.setTextSize(1, 20.0f);
        this.titleText.setTextColor(this.colors.getColor("HEADER"));
        if (!StringUtils.isEmpty(this.headerTextKey)) {
            this.titleText.setText((CharSequence)this.localizationService.getString(this.headerTextKey));
        } else {
            this.titleText.setText((CharSequence)this.getHeaderText());
        }
        this.titleText.setPadding(0, 0, 0, this.displayUtils.getDIP(2));
        this.titleText.setSingleLine(true);
        this.titleText.setEllipsize(TextUtils.TruncateAt.END);
        LinearLayout.LayoutParams titleTextLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        titleTextLayoutParams.gravity = 16;
        this.titleText.setLayoutParams((ViewGroup.LayoutParams)titleTextLayoutParams);
        this.titleImage = new ImageView(this.getContext());
        this.titleImage.setImageDrawable(this.drawables.getDrawable("socialize_icon_white.png"));
        this.titleImage.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams titleImageLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        titleImageLayoutParams.gravity = 16;
        titleImageLayoutParams.setMargins(eight, 0, four, 0);
        this.titleImage.setLayoutParams((ViewGroup.LayoutParams)titleImageLayoutParams);
        this.addView((View)this.titleImage);
        this.addView((View)this.titleText);
    }

    protected LayerDrawable newLayerDrawable(Drawable[] layers) {
        return new LayerDrawable(layers);
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderTextKey(String headerTextKey) {
        this.headerTextKey = headerTextKey;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

