/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.dialog;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.DialogRegistration;

public class SafeProgressDialog
extends ProgressDialog {
    private int dismissCount = 0;

    public SafeProgressDialog(Context context, int theme) {
        super(context, theme);
    }

    public SafeProgressDialog(Context context) {
        super(context);
    }

    public void dismissAll() {
        this.dismissCount = 0;
        this.dismiss();
    }

    public void dismiss() {
        try {
            if (this.dismissCount <= 1) {
                if (this.isShowing()) {
                    super.dismiss();
                }
            } else {
                --this.dismissCount;
            }
        }
        catch (Exception error) {
            SocializeLogger.e(error.getMessage(), error);
        }
    }

    public void show() {
        try {
            super.show();
        }
        catch (Throwable error) {
            SocializeLogger.e(error.getMessage(), error);
        }
    }

    public static SafeProgressDialog show(Context context, int dismissCount) {
        return SafeProgressDialog.show(context, "", "Please wait...", dismissCount);
    }

    public static SafeProgressDialog show(Context context) {
        return SafeProgressDialog.show(context, "", "Please wait...");
    }

    public static SafeProgressDialog show(Context context, String title, String message, int dismissCount) {
        SafeProgressDialog dlg = SafeProgressDialog.show(context, title, message);
        dlg.dismissCount = dismissCount;
        return dlg;
    }

    public static SafeProgressDialog show(Context context, String title, String message) {
        SafeProgressDialog dialog = SafeProgressDialog.makeDialog(context);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.show();
        DialogRegistration.register(context, (Dialog)dialog);
        return dialog;
    }

    protected static SafeProgressDialog makeDialog(Context context) {
        return new SafeProgressDialog(context);
    }
}

