/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.ui.dialog.DialogRegistration;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.SocializeButton;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;

public class FullScreenDialogFactory {
    private DisplayUtils displayUtils;
    private IBeanFactory<SocializeButton> buttonFactory;
    private Drawables drawables;

    public Dialog build(Activity context, View contentView, boolean includeCloseButton) {
        final Dialog dialog = new Dialog(contentView.getContext(), 16973835);
        dialog.requestWindowFeature(1);
        if (includeCloseButton) {
            Drawable viewBg = this.drawables.getDrawable("action_bar_button.png", true, false, true);
            LinearLayout layout = new LinearLayout((Context)context);
            layout.setOrientation(1);
            LinearLayout.LayoutParams master = new LinearLayout.LayoutParams(-1, -1);
            layout.setLayoutParams((ViewGroup.LayoutParams)master);
            LinearLayout toolbar = new LinearLayout((Context)context);
            LinearLayout.LayoutParams toolbarParams = new LinearLayout.LayoutParams(-1, this.displayUtils.getDIP(44));
            toolbar.setLayoutParams((ViewGroup.LayoutParams)toolbarParams);
            toolbar.setGravity(21);
            CompatUtils.setBackgroundDrawable((View)toolbar, viewBg);
            SocializeButton button = (SocializeButton)((Object)this.buttonFactory.getBean());
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            toolbar.addView((View)button);
            layout.addView((View)toolbar);
            layout.addView(contentView);
            dialog.setContentView((View)layout);
        } else {
            dialog.setContentView(contentView);
        }
        ColorDrawable cd = new ColorDrawable(-16777216);
        dialog.getWindow().setBackgroundDrawable((Drawable)cd);
        dialog.getWindow().setLayout(-1, -1);
        DialogRegistration.register(contentView.getContext(), dialog);
        return dialog;
    }

    public void setDisplayUtils(DisplayUtils displayUtils) {
        this.displayUtils = displayUtils;
    }

    public void setButtonFactory(IBeanFactory<SocializeButton> buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }
}

