/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.socialize.android.ioc.BeanCreationListener;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.BaseDialogFactory;
import com.socialize.ui.dialog.DialogPanelView;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.ui.dialog.SocializeDialogListener;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;

public abstract class AsyncDialogFactory<V extends DialogPanelView, L extends SocializeDialogListener<V>>
extends BaseDialogFactory {
    private IBeanFactory<V> panelViewFactory;
    private DisplayUtils displayUtils;
    private Colors colors;
    protected SocializeLogger logger;

    protected void preload(Context context, Object ... args) {
        this.panelViewFactory.getBeanAsync(null, args);
    }

    protected void showDialog(Context context, BeanCreationListener<V> beanListener, L listener, Object ... args) {
        final Dialog dialog = this.newDialog(context);
        final SafeProgressDialog progress = SafeProgressDialog.show(context, "", "Please wait...");
        this.panelViewFactory.getBeanAsync(new BeanCreationListener<V>((BeanCreationListener)beanListener, (SocializeDialogListener)listener){
            final /* synthetic */ BeanCreationListener val$beanListener;
            final /* synthetic */ SocializeDialogListener val$listener;
            {
                this.val$beanListener = beanCreationListener;
                this.val$listener = socializeDialogListener;
            }

            public void onError(String name, Exception e) {
                dialog.dismiss();
                progress.dismiss();
                if (AsyncDialogFactory.this.logger != null) {
                    AsyncDialogFactory.this.logger.error("Error creating dialog", (Throwable)e);
                } else {
                    SocializeLogger.e(e.getMessage(), e);
                }
                if (this.val$beanListener != null) {
                    this.val$beanListener.onError(name, e);
                }
            }

            public void onCreate(V view) {
                if (this.val$beanListener != null) {
                    this.val$beanListener.onCreate(view);
                }
                ((DialogPanelView)view).setDialog(dialog);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
                params.gravity = 17;
                GradientDrawable background = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{AsyncDialogFactory.this.colors.getColor("AUTH_REQUEST_DIALOG_BOTTOM"), AsyncDialogFactory.this.colors.getColor("AUTH_REQUEST_DIALOG_TOP")});
                background.setCornerRadius((float)AsyncDialogFactory.this.displayUtils.getDIP(4));
                CompatUtils.setBackgroundDrawable(view, (Drawable)background);
                dialog.setContentView(view, (ViewGroup.LayoutParams)params);
                dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dlg) {
                        if (val$listener != null) {
                            val$listener.onCancel(dialog);
                        }
                    }
                });
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                lp.copyFrom(dialog.getWindow().getAttributes());
                lp.width = -2;
                lp.height = -2;
                lp.horizontalMargin = 0.0f;
                lp.verticalMargin = 0.0f;
                dialog.getWindow().setAttributes(lp);
                progress.dismiss();
                try {
                    dialog.show();
                    if (this.val$listener != null) {
                        this.val$listener.onShow(dialog, view);
                    }
                }
                catch (Exception e) {
                    if (AsyncDialogFactory.this.logger != null) {
                        AsyncDialogFactory.this.logger.warn("Error displaying dialog", (Throwable)e);
                    }
                    SocializeLogger.e(e.getMessage(), e);
                }
            }
        }, args);
    }

    public void setPanelViewFactory(IBeanFactory<V> panelViewFactory) {
        this.panelViewFactory = panelViewFactory;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

