/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Toast;
import com.socialize.CommentUtils;
import com.socialize.Socialize;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.comment.CommentDeleteListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.comment.CommentActivity;
import com.socialize.ui.comment.CommentEditField;
import com.socialize.ui.comment.CommentListItem;
import com.socialize.ui.comment.CommentListView;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.ui.slider.ActionBarSliderView;
import com.socialize.ui.view.EntityView;

public class CommentView
extends EntityView {
    private Dialog progress;
    private CommentListView commentListView;
    private boolean headerDisplayed = true;
    private Entity entity;
    private SocializeConfig config;
    private OnCommentViewActionListener onCommentViewActionListener;
    public static final String COMMENT_LISTENER = "socialize.comment.listener";

    public CommentView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CommentView(Context context) {
        super(context);
    }

    @Override
    protected View getView(Bundle bundle, Object ... entityKey) {
        if (entityKey != null || this.entity != null) {
            if (this.commentListView == null) {
                if (this.entity == null) {
                    this.entity = (Entity)entityKey[0];
                }
                this.commentListView = (CommentListView)this.container.getBean("commentList");
                this.config = (SocializeConfig)this.container.getBean("config");
                this.commentListView.setEntity(this.entity);
                this.commentListView.setHeaderDisplayed(this.headerDisplayed);
                ListenerHolder holder = (ListenerHolder)this.container.getBean("listenerHolder");
                if (holder != null) {
                    this.onCommentViewActionListener = (OnCommentViewActionListener)holder.pop(COMMENT_LISTENER);
                    this.commentListView.setOnCommentViewActionListener(this.onCommentViewActionListener);
                }
                ((Activity)this.getContext()).registerForContextMenu(this.commentListView.getContent().getMainView());
            }
            return this.commentListView;
        }
        SocializeLogger.e("No entity url specified for comment view");
        return null;
    }

    @Override
    protected void onBeforeSocializeInit() {
        if (!Socialize.getSocialize().isInitialized(this.getContext()) || !Socialize.getSocialize().isAuthenticated()) {
            try {
                this.progress = SafeProgressDialog.show(this.getContext(), "Loading Comments", "Please wait...");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onAfterAuthenticate(IOCContainer container) {
        if (this.progress != null) {
            try {
                this.progress.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected String[] getBundleKeys() {
        return new String[]{"socialize.entity"};
    }

    public void onProfileUpdate() {
        if (this.commentListView != null) {
            this.commentListView.onProfileUpdate();
        }
    }

    public void reload() {
        if (this.commentListView != null) {
            this.commentListView.reload();
        }
    }

    @Override
    public View getLoadingView() {
        return null;
    }

    public ActionBarSliderView getCommentEntryViewSlider() {
        return this.commentListView == null ? null : this.commentListView.getCommentEntryViewSlider();
    }

    public CommentEditField getCommentEntryField() {
        return this.commentListView == null ? null : this.commentListView.getCommentEntryField();
    }

    public boolean isHeaderDisplayed() {
        return this.headerDisplayed;
    }

    public void setHeaderDisplayed(boolean headerDisplayed) {
        this.headerDisplayed = headerDisplayed;
        if (this.commentListView != null) {
            this.commentListView.setHeaderDisplayed(headerDisplayed);
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    @Override
    protected boolean onSettingsMenuItemClick(MenuItem item) {
        return this.onCommentViewActionListener != null && this.onCommentViewActionListener.onSettingsMenuItemClick(item);
    }

    @Override
    protected void createOptionsMenuItem(Activity source, Menu menu) {
        super.createOptionsMenuItem(source, menu);
        MenuItem add2 = menu.add((CharSequence)"Refresh");
        if (this.drawables != null) {
            add2.setIcon(this.drawables.getDrawable("ic_menu_refresh.png"));
        }
        add2.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (CommentView.this.onCommentViewActionListener == null || !CommentView.this.onCommentViewActionListener.onRefreshMenuItemClick(item)) {
                    CommentView.this.reload();
                }
                return true;
            }
        });
    }

    public void onCreateContextMenu(CommentActivity commentActivity, ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.config.isAllowDeleteComment()) {
            try {
                AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
                CommentListItem item = (CommentListItem)info.targetView;
                if (item != null && item.isDeleteOk()) {
                    menu.setHeaderTitle((CharSequence)"Delete");
                    menu.add(0, 0, 0, (CharSequence)"Delete this comment");
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    public CommentListView getCommentListView() {
        return this.commentListView;
    }

    public boolean onContextItemSelected(final CommentActivity commentActivity, MenuItem item) {
        if (this.config.isAllowDeleteComment()) {
            try {
                AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
                CommentListItem cli = (CommentListItem)info.targetView;
                if (cli != null && cli.isDeleteOk()) {
                    final SafeProgressDialog progress = SafeProgressDialog.show((Context)commentActivity);
                    CommentUtils.deleteComment(commentActivity, cli.getCommentObject().getId(), new CommentDeleteListener(){

                        @Override
                        public void onError(SocializeException error) {
                            progress.dismiss();
                            Toast.makeText((Context)commentActivity, (CharSequence)"Failed to delete comment", (int)0).show();
                            Log.e((String)"Socialize", (String)"Failed to delete comment", (Throwable)error);
                        }

                        @Override
                        public void onDelete() {
                            progress.dismiss();
                            Toast.makeText((Context)commentActivity, (CharSequence)"Comment deleted", (int)0).show();
                            CommentView.this.reload();
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return false;
    }
}

