/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import com.socialize.ui.util.Colors;

public class CommentListItemBackgroundFactory {
    private Drawable background;
    private int bgColor;
    private int topColor;
    private int bottomColor;
    private Colors colors;

    public void init() {
        this.bgColor = this.colors.getColor("LIST_ITEM_BG");
        this.topColor = this.colors.getColor("LIST_ITEM_TOP");
        this.bottomColor = this.colors.getColor("LIST_ITEM_BOTTOM");
        this.background = this.makeDefaultBackground();
    }

    public Drawable getBackground() {
        return this.background;
    }

    protected Drawable makeDefaultBackground() {
        PaintDrawable shadow = new PaintDrawable(this.bottomColor);
        PaintDrawable highlight = new PaintDrawable(this.topColor);
        PaintDrawable surface = new PaintDrawable(this.bgColor);
        LayerDrawable layers = new LayerDrawable(new Drawable[]{shadow, highlight, surface});
        layers.setLayerInset(0, 0, 0, 0, 0);
        layers.setLayerInset(1, 0, 0, 0, 1);
        layers.setLayerInset(2, 0, 1, 0, 1);
        return layers;
    }

    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }
}

