/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.socialize.Socialize;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.i18n.LocalizationService;
import com.socialize.ui.comment.CommentAddButtonListener;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.util.KeyboardUtils;
import com.socialize.ui.view.CustomCheckbox;
import com.socialize.ui.view.SocializeButton;
import com.socialize.util.AppUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.view.BaseView;

public class CommentEntryView
extends BaseView {
    private CommentAddButtonListener listener;
    private SocializeButton postCommentButton;
    private SocializeButton cancelCommentButton;
    private SocializeButton subscribeNotificationButton;
    private DisplayUtils displayUtils;
    private AppUtils appUtils;
    private Drawables drawables;
    private Colors colors;
    private KeyboardUtils keyboardUtils;
    private EditText commentField;
    private LocalizationService localizationService;
    private IBeanFactory<CustomCheckbox> locationEnabledOptionFactory;
    private IBeanFactory<CustomCheckbox> notificationEnabledOptionFactory;
    private CustomCheckbox locationCheckBox;
    private CustomCheckbox notifyCheckBox;
    private boolean notificationsEnabled = true;
    private boolean notificationsAvailable = true;
    private TextView notificationsTitle;
    private TextView notificationsText;
    private ImageView notificationBannerImage;
    private Toast toaster;

    public CommentEntryView(Context context, CommentAddButtonListener listener) {
        super(context);
        this.listener = listener;
    }

    public void init() {
        int padding = this.displayUtils.getDIP(4);
        int textPadding = this.displayUtils.getDIP(2);
        this.notificationsEnabled = true;
        this.notificationsAvailable = this.appUtils.isNotificationsAvailable(this.getContext());
        LinearLayout.LayoutParams fill = new LinearLayout.LayoutParams(-1, -1);
        fill.setMargins(0, 0, 0, 0);
        this.setOrientation(1);
        this.setGravity(49);
        CompatUtils.setBackgroundDrawable((View)this, this.drawables.getDrawable("slate.png", true, true, true));
        this.setLayoutParams((ViewGroup.LayoutParams)fill);
        LinearLayout buttonLayoutLeft = new LinearLayout(this.getContext());
        LinearLayout buttonLayoutRight = new LinearLayout(this.getContext());
        LinearLayout buttonLayout = new LinearLayout(this.getContext());
        LinearLayout commentLayout = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams buttonLayoutLeftParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams buttonLayoutRightParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams buttonLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout.LayoutParams commentFieldParams = new LinearLayout.LayoutParams(-1, -2);
        buttonLayoutLeftParams.weight = 1.0f;
        buttonLayout.setOrientation(0);
        buttonLayout.setGravity(5);
        buttonLayout.setPadding(padding, padding, padding, padding);
        buttonLayout.setLayoutParams((ViewGroup.LayoutParams)buttonLayoutParams);
        buttonLayoutLeft.setLayoutParams((ViewGroup.LayoutParams)buttonLayoutLeftParams);
        buttonLayoutRight.setLayoutParams((ViewGroup.LayoutParams)buttonLayoutRightParams);
        commentLayout.setPadding(textPadding, textPadding, textPadding, 0);
        buttonLayout.addView((View)buttonLayoutLeft);
        buttonLayout.addView((View)buttonLayoutRight);
        if (this.notificationsAvailable) {
            this.notifyCheckBox = (CustomCheckbox)this.notificationEnabledOptionFactory.getBean();
        }
        if (this.notifyCheckBox != null) {
            this.notifyCheckBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommentEntryView.this.toggleNotifications();
                    String msg = null;
                    msg = CommentEntryView.this.notifyCheckBox.isChecked() ? "Notifications enabled" : "Notifications disabled";
                    CommentEntryView.this.toast(msg);
                }
            });
        }
        this.commentField = new EditText(this.getContext());
        this.commentField.setTextSize(1, 14.0f);
        this.commentField.setGravity(51);
        this.commentField.setLines(5);
        this.commentField.setLayoutParams((ViewGroup.LayoutParams)commentFieldParams);
        commentLayout.addView((View)this.commentField);
        if (this.cancelCommentButton != null) {
            this.cancelCommentButton.setCustomClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommentEntryView.this.reset();
                    CommentEntryView.this.listener.onCancel();
                }
            });
            buttonLayoutLeft.addView((View)this.cancelCommentButton);
        }
        if (this.postCommentButton != null) {
            this.postCommentButton.setCustomClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommentEntryView.this.postCommentButton.setEnabled(false);
                    CommentEntryView.this.keyboardUtils.hideKeyboard((View)CommentEntryView.this.commentField);
                    boolean shareLocation = false;
                    if (CommentEntryView.this.locationCheckBox != null) {
                        shareLocation = CommentEntryView.this.locationCheckBox.isChecked();
                    }
                    CommentEntryView.this.listener.onComment(CommentEntryView.this.commentField.getText().toString().trim(), shareLocation, CommentEntryView.this.notificationsEnabled);
                }
            });
            buttonLayoutRight.addView((View)this.postCommentButton);
        }
        if (this.subscribeNotificationButton != null) {
            this.subscribeNotificationButton.setCustomClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommentEntryView.this.toggleNotifications();
                }
            });
        }
        this.addView((View)commentLayout);
        this.addView((View)buttonLayout);
        this.initLocationToolbar();
        if (this.notificationsAvailable && this.displayUtils.getOrientation() == 1) {
            LinearLayout notificationMasterLayout = new LinearLayout(this.getContext());
            LinearLayout.LayoutParams notificationMasterLayoutParams = new LinearLayout.LayoutParams(-1, -1);
            notificationMasterLayoutParams.gravity = 17;
            notificationMasterLayoutParams.weight = 1.0f;
            notificationMasterLayoutParams.setMargins(0, this.displayUtils.getDIP(20), 0, 0);
            notificationMasterLayout.setLayoutParams((ViewGroup.LayoutParams)notificationMasterLayoutParams);
            LinearLayout notificationContentLayout = new LinearLayout(this.getContext());
            LinearLayout.LayoutParams notificationContentLayoutParams = new LinearLayout.LayoutParams(-1, -1);
            notificationContentLayout.setOrientation(1);
            notificationContentLayoutParams.gravity = 17;
            notificationContentLayout.setLayoutParams((ViewGroup.LayoutParams)notificationContentLayoutParams);
            this.notificationBannerImage = new ImageView(this.getContext());
            LinearLayout.LayoutParams notificationBannerParams = new LinearLayout.LayoutParams(-1, -2);
            notificationBannerParams.gravity = 17;
            this.notificationBannerImage.setLayoutParams((ViewGroup.LayoutParams)notificationBannerParams);
            this.notificationBannerImage.setImageDrawable(this.drawables.getDrawable("notification_banner.png"));
            this.notificationsTitle = new TextView(this.getContext());
            this.notificationsText = new TextView(this.getContext());
            this.notificationsTitle.setTextSize(1, 16.0f);
            this.notificationsText.setTextSize(1, 12.0f);
            this.notificationsTitle.setGravity(17);
            this.notificationsText.setGravity(17);
            this.notificationsTitle.setTextColor(-1);
            this.notificationsTitle.setTypeface(Typeface.DEFAULT_BOLD);
            this.notificationsText.setTextColor(-7829368);
            notificationContentLayout.addView((View)this.notificationBannerImage);
            notificationContentLayout.addView((View)this.notificationsTitle);
            notificationContentLayout.addView((View)this.notificationsText);
            if (this.subscribeNotificationButton != null) {
                LinearLayout.LayoutParams subscribeNotificationButtonLayoutParams = new LinearLayout.LayoutParams(this.subscribeNotificationButton.getButtonWidth().intValue(), this.subscribeNotificationButton.getButtonHeight().intValue());
                subscribeNotificationButtonLayoutParams.setMargins(0, this.displayUtils.getDIP(20), 0, 0);
                subscribeNotificationButtonLayoutParams.gravity = 17;
                this.subscribeNotificationButton.setLayoutParams((ViewGroup.LayoutParams)subscribeNotificationButtonLayoutParams);
                notificationContentLayout.addView((View)this.subscribeNotificationButton);
            }
            notificationMasterLayout.addView((View)notificationContentLayout);
            this.addView((View)notificationMasterLayout);
        }
    }

    protected void initLocationToolbar() {
        if (this.appUtils.isLocationAvailable(this.getContext())) {
            UserSettings settings = Socialize.getSocialize().getSession().getUserSettings();
            int padding = this.displayUtils.getDIP(4);
            LinearLayout toolbarLayout = new LinearLayout(this.getContext());
            LinearLayout toolbarLayoutLeft = new LinearLayout(this.getContext());
            LinearLayout toolbarLayoutRight = new LinearLayout(this.getContext());
            LinearLayout.LayoutParams toolbarLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            LinearLayout.LayoutParams toolbarLayoutLeftParams = new LinearLayout.LayoutParams(-2, -2);
            LinearLayout.LayoutParams toolbarLayoutRightParams = new LinearLayout.LayoutParams(-2, -2);
            GradientDrawable background = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("COMMENT_ENTRY_BOTTOM"), this.colors.getColor("COMMENT_ENTRY_TOP")});
            CompatUtils.setBackgroundDrawable((View)toolbarLayout, (Drawable)background);
            toolbarLayout.setPadding(padding, padding, padding, padding);
            toolbarLayoutLeftParams.weight = 1.0f;
            toolbarLayout.setLayoutParams((ViewGroup.LayoutParams)toolbarLayoutParams);
            toolbarLayoutLeft.setLayoutParams((ViewGroup.LayoutParams)toolbarLayoutLeftParams);
            toolbarLayoutRight.setLayoutParams((ViewGroup.LayoutParams)toolbarLayoutRightParams);
            toolbarLayoutRight.setOrientation(0);
            toolbarLayoutLeft.setOrientation(0);
            toolbarLayout.addView((View)toolbarLayoutLeft);
            toolbarLayout.addView((View)toolbarLayoutRight);
            this.locationCheckBox = (CustomCheckbox)this.locationEnabledOptionFactory.getBean();
            this.locationCheckBox.setChecked(settings.isLocationEnabled());
            toolbarLayoutLeft.addView((View)this.locationCheckBox);
            if (this.notifyCheckBox != null && this.displayUtils.getOrientation() != 1) {
                toolbarLayoutRight.addView((View)this.notifyCheckBox);
            }
            this.addView((View)toolbarLayout);
        }
    }

    protected void toggleNotifications() {
        this.setNotificationsEnabled(!this.notificationsEnabled);
    }

    @Override
    public void onViewRendered(int width, int height) {
        super.onViewRendered(width, height);
        this.commentField.requestFocus();
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setKeyboardUtils(KeyboardUtils keyboardUtils) {
        this.keyboardUtils = keyboardUtils;
    }

    public void setPostCommentButton(SocializeButton facebookShareButton) {
        this.postCommentButton = facebookShareButton;
    }

    public void setCancelCommentButton(SocializeButton cancelCommentButton) {
        this.cancelCommentButton = cancelCommentButton;
    }

    public void setLocationEnabledOptionFactory(IBeanFactory<CustomCheckbox> locationEnabledOptionFactory) {
        this.locationEnabledOptionFactory = locationEnabledOptionFactory;
    }

    public void setSubscribeNotificationButton(SocializeButton subscribeNotificationButton) {
        this.subscribeNotificationButton = subscribeNotificationButton;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setNotificationEnabledOptionFactory(IBeanFactory<CustomCheckbox> notificationOptionFactory) {
        this.notificationEnabledOptionFactory = notificationOptionFactory;
    }

    public void setNotificationsEnabled(boolean enabled) {
        this.notificationsEnabled = enabled;
        this.updateUI();
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected void updateUI() {
        SocializeSession session;
        if (this.notificationsAvailable) {
            if (this.notificationsText != null) {
                this.notificationsText.setVisibility(0);
            }
            if (this.notificationsTitle != null) {
                this.notificationsTitle.setVisibility(0);
            }
            if (this.subscribeNotificationButton != null) {
                this.subscribeNotificationButton.setVisibility(0);
            }
            if (this.notificationBannerImage != null) {
                this.notificationBannerImage.setVisibility(0);
            }
            if (this.notificationsEnabled) {
                if (this.notificationsText != null) {
                    this.notificationsText.setText((CharSequence)this.localizationService.getString("socialize_comment_smartalerts_subscribed_willnotify"));
                }
                if (this.notificationsTitle != null) {
                    this.notificationsTitle.setText((CharSequence)this.localizationService.getString("socialize_comment_smartalerts_subscribed_yes"));
                }
                if (this.subscribeNotificationButton != null) {
                    this.subscribeNotificationButton.setTextKey("socialize_comment_smartalerts_unsubscribe");
                }
            } else {
                if (this.notificationsText != null) {
                    this.notificationsText.setText((CharSequence)this.localizationService.getString("socialize_comment_smartalerts_subscribe_ask"));
                }
                if (this.notificationsTitle != null) {
                    this.notificationsTitle.setText((CharSequence)this.localizationService.getString("socialize_comment_smartalerts_subscribed_no"));
                }
                if (this.subscribeNotificationButton != null) {
                    this.subscribeNotificationButton.setTextKey("socialize_comment_smartalerts_subscribe");
                }
            }
        } else {
            if (this.notificationsText != null) {
                this.notificationsText.setVisibility(8);
            }
            if (this.notificationsTitle != null) {
                this.notificationsTitle.setVisibility(8);
            }
            if (this.subscribeNotificationButton != null) {
                this.subscribeNotificationButton.setVisibility(8);
            }
            if (this.notificationBannerImage != null) {
                this.notificationBannerImage.setVisibility(8);
            }
        }
        if (this.notifyCheckBox != null) {
            this.notifyCheckBox.setChecked(this.notificationsEnabled);
        }
        if (this.postCommentButton != null) {
            this.postCommentButton.setEnabled(true);
        }
        if ((session = Socialize.getSocialize().getSession()) != null && this.locationCheckBox != null && !this.locationCheckBox.isChanged()) {
            this.locationCheckBox.setChecked(session.getUserSettings().isLocationEnabled());
        }
    }

    protected void toast(String text) {
        if (this.toaster != null) {
            this.toaster.cancel();
            this.toaster.setText((CharSequence)text);
        } else {
            this.toaster = Toast.makeText((Context)this.getContext(), (CharSequence)text, (int)0);
        }
        this.toaster.show();
    }

    protected void reset() {
        this.keyboardUtils.hideKeyboard((View)this.commentField);
        this.commentField.setText((CharSequence)"");
    }

    public void update() {
        UserSettings user;
        SocializeSession session;
        if (this.locationCheckBox != null) {
            this.locationCheckBox.setChanged(false);
        }
        if ((session = Socialize.getSocialize().getSession()) != null && (user = session.getUserSettings()) != null) {
            this.notificationsAvailable = user.isNotificationsEnabled() && this.appUtils.isNotificationsAvailable(this.getContext());
        }
        this.updateUI();
    }

    public EditText getCommentField() {
        return this.commentField;
    }

    protected CustomCheckbox getLocationCheckBox() {
        return this.locationCheckBox;
    }

    protected CustomCheckbox getNotifyCheckBox() {
        return this.notifyCheckBox;
    }

    protected SocializeButton getPostCommentButton() {
        return this.postCommentButton;
    }

    protected void setNotifySubscribeState(boolean subscribed) {
        if (subscribed) {
            this.notificationsEnabled = subscribed;
        }
        if (this.notifyCheckBox != null) {
            this.notifyCheckBox.setChecked(this.notificationsEnabled);
            this.updateUI();
        }
    }
}

