/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.socialize.Socialize;
import com.socialize.UserUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.Comment;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.comment.CommentListItem;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.image.ImageLoader;
import com.socialize.ui.util.DateUtils;
import com.socialize.ui.view.CachedImageView;
import com.socialize.ui.view.ListItemLoadingView;
import com.socialize.util.CacheableDrawable;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;

public class CommentAdapter
extends BaseAdapter {
    private IBeanFactory<CommentListItem> commentItemViewFactory;
    private IBeanFactory<ListItemLoadingView> listItemLoadingViewFactory;
    private OnCommentViewActionListener onCommentViewActionListener;
    private List<Comment> comments;
    private SocializeLogger logger;
    private Drawables drawables;
    private View loadingView;
    private DisplayUtils displayUtils;
    private DateUtils dateUtils;
    private ImageLoader imageLoader;
    private WeakReference<Context> context;
    private boolean last = false;
    private Date now;
    private int totalCount = 0;
    private int count = 0;
    private int viewCacheCount = 20;
    private int viewCacheIndex = 0;
    private int iconSize = 64;
    private int densitySize = 64;
    private final CommentListItem[] viewCache = new CommentListItem[this.viewCacheCount];

    public void init(Context context) {
        this.context = new WeakReference<Context>(context);
        this.now = new Date();
        if (this.displayUtils != null) {
            this.densitySize = this.displayUtils.getDIP(this.iconSize);
        }
        if (this.commentItemViewFactory != null) {
            for (int i = 0; i < this.viewCacheCount; ++i) {
                this.viewCache[i] = (CommentListItem)((Object)this.commentItemViewFactory.getBean());
            }
        }
        this.viewCacheIndex = 0;
    }

    public void reset() {
        if (this.comments != null) {
            this.comments.clear();
        }
        this.last = false;
        this.now = new Date();
        this.viewCacheIndex = 0;
        this.totalCount = 0;
        this.count = 0;
        this.notifyDataSetChanged();
        this.notifyDataSetInvalidated();
    }

    public int getCount() {
        return this.count;
    }

    public boolean isDisplayLoading() {
        return !this.last && this.comments != null && this.comments.size() > 0;
    }

    public Object getItem(int position) {
        if (this.comments != null && position < this.comments.size()) {
            return this.comments.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (!this.isDisplayLoading() || position < this.comments.size()) {
            return 0;
        }
        return 1;
    }

    public int getViewTypeCount() {
        if (!this.isDisplayLoading()) {
            return 1;
        }
        return 2;
    }

    public View getView(int position, View oldView, ViewGroup parent) {
        Object returnView = null;
        CommentListItem view = null;
        if (oldView instanceof CommentListItem) {
            view = (CommentListItem)oldView;
        }
        User tmpUser = null;
        final Comment item = (Comment)this.getItem(position);
        if (item != null) {
            tmpUser = item.getUser();
        }
        User currentUser = null;
        if (Socialize.getSocialize().getSession() != null) {
            currentUser = Socialize.getSocialize().getSession().getUser();
        }
        if (currentUser != null && tmpUser != null && currentUser.getId().equals(tmpUser.getId())) {
            tmpUser = currentUser;
        }
        final User user = tmpUser;
        if (view == null) {
            view = this.viewCacheIndex < this.viewCacheCount ? this.viewCache[this.viewCacheIndex++] : (CommentListItem)((Object)this.commentItemViewFactory.getBean());
        }
        if (view != null) {
            view.setCommentObject(item);
            view.setDeleteOk(false);
            view.setOnClickListener(null);
            view.setOnCreateContextMenuListener(null);
            returnView = view;
            if (position >= this.comments.size()) {
                if (this.loadingView == null) {
                    this.loadingView = (View)this.listItemLoadingViewFactory.getBean();
                    this.loadingView.setTag(null);
                }
                returnView = this.loadingView;
            } else if (item != null) {
                block35: {
                    String displayName;
                    String imageUrl = null;
                    if (user != null) {
                        imageUrl = user.getSmallImageUri();
                        displayName = user.getDisplayName();
                        if (displayName == null && (displayName = item.getUser().getDisplayName()) == null) {
                            displayName = "Anonymous";
                        }
                        if (currentUser != null) {
                            view.setDeleteOk(user.getId().equals(currentUser.getId()));
                        }
                        final CommentListItem fItem = view;
                        view.getContentLayout().setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (CommentAdapter.this.onCommentViewActionListener == null || !CommentAdapter.this.onCommentViewActionListener.onCommentItemClicked(fItem)) {
                                    CommentAdapter.this.handleItemClick(user, item);
                                }
                            }
                        });
                        view.getIconLayout().setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (CommentAdapter.this.onCommentViewActionListener == null || !CommentAdapter.this.onCommentViewActionListener.onCommentIconClicked(fItem)) {
                                    CommentAdapter.this.handleItemClick(user, item);
                                }
                            }
                        });
                    } else {
                        displayName = "Anonymous";
                    }
                    if (this.onCommentViewActionListener != null) {
                        this.onCommentViewActionListener.onBeforeSetComment(item, view);
                    }
                    TextView comment = view.getCommentText();
                    TextView userName = view.getAuthor();
                    TextView time = view.getTime();
                    ImageView locationIcon = view.getLocationIcon();
                    CachedImageView userIcon = view.getUserIcon();
                    if (comment != null) {
                        comment.setText((CharSequence)item.getText());
                    }
                    if (userName != null) {
                        userName.setText((CharSequence)displayName);
                    }
                    if (locationIcon != null) {
                        if (item.hasLocation() && item.isLocationShared()) {
                            locationIcon.setVisibility(0);
                        } else {
                            locationIcon.setVisibility(8);
                        }
                    }
                    if (time != null) {
                        Long date = item.getDate();
                        if (date != null && date > 0L) {
                            long diff = this.now.getTime() - date;
                            time.setText((CharSequence)(this.dateUtils.getTimeString(diff) + " "));
                        } else {
                            time.setText((CharSequence)" ");
                        }
                    }
                    if (userIcon != null && this.drawables != null && user != null) {
                        if (userIcon.getBackground() != null) {
                            userIcon.getBackground().setAlpha(255);
                        }
                        if (!StringUtils.isEmpty(imageUrl)) {
                            try {
                                CacheableDrawable cached = (CacheableDrawable)this.drawables.getCache().get(imageUrl);
                                if (cached != null && !cached.isRecycled()) {
                                    if (this.logger != null && this.logger.isDebugEnabled()) {
                                        this.logger.debug("CommentAdpater setting image icon to cached image " + cached);
                                    }
                                    userIcon.setExpectedImageName(imageUrl);
                                    userIcon.setImageUrlImmediate(imageUrl, false);
                                    break block35;
                                }
                                userIcon.setExpectedImageName(imageUrl);
                                userIcon.setDefaultImage();
                                this.imageLoader.loadImageByUrl(imageUrl, this.densitySize, this.densitySize, userIcon);
                            }
                            catch (Exception e) {
                                String errorMsg = "Not a valid image uri [" + imageUrl + "]";
                                this.logError(errorMsg, e);
                                userIcon.setExpectedImageName("default_user_icon.png");
                                userIcon.setDefaultImage();
                            }
                        } else if (!StringUtils.isEmpty(user.getProfilePicData())) {
                            userIcon.setDefaultImage();
                            userIcon.setExpectedImageName("user_" + user.getId());
                            this.imageLoader.loadImageByData("user_" + user.getId(), user.getProfilePicData(), this.densitySize, this.densitySize, userIcon);
                        } else {
                            userIcon.setExpectedImageName("default_user_icon.png");
                            userIcon.setDefaultImage();
                        }
                    }
                }
                if (this.onCommentViewActionListener != null) {
                    this.onCommentViewActionListener.onAfterSetComment(item, view);
                }
            }
        }
        if (returnView == null) {
            returnView = oldView;
        }
        return returnView;
    }

    private void handleItemClick(User user, SocializeAction item) {
        if (user != null && user.getId() != null) {
            Context ctx = (Context)this.context.get();
            if (ctx instanceof Activity) {
                UserUtils.showUserProfileWithAction((Activity)ctx, user, item);
            }
        } else if (this.logger != null) {
            this.logger.warn("No user for comment " + item.getId());
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        int extra = 0;
        if (this.isDisplayLoading()) {
            extra = 1;
        }
        this.count = this.comments == null ? 0 : this.comments.size() + extra;
    }

    public void setCommentItemViewFactory(IBeanFactory<CommentListItem> commentItemViewFactory) {
        this.commentItemViewFactory = commentItemViewFactory;
    }

    public void setListItemLoadingViewFactory(IBeanFactory<ListItemLoadingView> listItemLoadingViewFactory) {
        this.listItemLoadingViewFactory = listItemLoadingViewFactory;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setLoadingView(View loadingView) {
        this.loadingView = loadingView;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setDateUtils(DateUtils dateUtils) {
        this.dateUtils = dateUtils;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public OnCommentViewActionListener getOnCommentViewActionListener() {
        return this.onCommentViewActionListener;
    }

    public void setOnCommentViewActionListener(OnCommentViewActionListener onCommentViewActionListener) {
        this.onCommentViewActionListener = onCommentViewActionListener;
    }

    protected void logError(String msg, Exception e) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }
}

