/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.auth;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.api.SocializeSessionPersister;
import com.socialize.auth.AuthProviderType;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.facebook.FacebookSignInCell;
import com.socialize.networks.twitter.TwitterSignInCell;
import com.socialize.ui.auth.AnonymousCell;
import com.socialize.ui.auth.AuthDialogListener;
import com.socialize.ui.dialog.DialogPanelView;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.share.RememberCell;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.ClickableSectionCell;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;

public class AuthPanelView
extends DialogPanelView {
    private Colors colors;
    private Drawables drawables;
    private DisplayUtils displayUtils;
    private IBeanFactory<FacebookSignInCell> facebookSignInCellFactory;
    private IBeanFactory<TwitterSignInCell> twitterSignInCellFactory;
    private IBeanFactory<AnonymousCell> anonCellFactory;
    private IBeanFactory<RememberCell> rememberAuthCellFactory;
    private SocializeConfig config;
    private SocializeSessionPersister sessionPersister;
    private LocalizationService localizationService;
    private AuthDialogListener authDialogListener;
    private FacebookSignInCell facebookSignInCell;
    private TwitterSignInCell twitterSignInCell;
    private AnonymousCell anonymousCell;
    private RememberCell rememberCell;
    private TextView skipAuth;
    float radii = 6.0f;
    int padding = 8;
    int headerHeight = 45;
    float headerRadius = 3.0f;
    private final float[] fbRadii = new float[]{this.radii, this.radii, this.radii, this.radii, 0.0f, 0.0f, 0.0f, 0.0f};
    private final int[] fbStroke = new int[]{1, 1, 0, 1};
    private final float[] twRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.radii, this.radii, this.radii, this.radii};
    private final int[] twStroke = new int[]{1, 1, 1, 1};

    public AuthPanelView(Context context) {
        super(context);
    }

    public AuthPanelView(Context context, AuthDialogListener listener) {
        super(context);
        this.authDialogListener = listener;
    }

    public void init() {
        boolean landscape = false;
        boolean lowRes = false;
        if (this.displayUtils != null) {
            this.padding = this.displayUtils.getDIP(12);
            this.headerRadius = this.displayUtils.getDIP(3);
            this.headerHeight = this.displayUtils.getDIP(45);
            this.radii = this.displayUtils.getDIP(8);
            landscape = this.displayUtils.isLandscape();
            lowRes = this.displayUtils.isLowRes();
        }
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, -2);
        masterParams.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        this.setOrientation(1);
        RelativeLayout container = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-1, -1);
        containerParams.gravity = 49;
        containerParams.weight = 1.0f;
        container.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.makeAuthButtons();
        View header = this.makeHeaderView(this.headerHeight, this.headerRadius);
        RelativeLayout.LayoutParams contentParams = new RelativeLayout.LayoutParams(-1, -2);
        contentParams.addRule(13);
        LinearLayout contentLayout = new LinearLayout(this.getContext());
        contentLayout.setPadding(this.padding, this.padding, this.padding, 0);
        contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        contentLayout.setGravity(49);
        LinearLayout.LayoutParams socialNetworkButtonParams = new LinearLayout.LayoutParams(-1, -2);
        contentLayout.setOrientation(1);
        LinearLayout socialNetworkButtonLayout = new LinearLayout(this.getContext());
        socialNetworkButtonLayout.setPadding(0, 0, 0, 0);
        socialNetworkButtonLayout.setOrientation(1);
        socialNetworkButtonLayout.setLayoutParams((ViewGroup.LayoutParams)socialNetworkButtonParams);
        if (!landscape && !lowRes) {
            View shareBadge = this.makeShareBadge();
            contentLayout.addView(shareBadge);
        }
        if (this.facebookSignInCell != null || this.twitterSignInCell != null) {
            if (this.facebookSignInCell != null) {
                socialNetworkButtonLayout.addView((View)this.facebookSignInCell);
            }
            if (this.twitterSignInCell != null) {
                socialNetworkButtonLayout.addView((View)this.twitterSignInCell);
            }
            contentLayout.addView((View)socialNetworkButtonLayout);
        }
        if (this.anonymousCell != null) {
            contentLayout.addView((View)this.anonymousCell);
        }
        LinearLayout.LayoutParams skipAuthParams = new LinearLayout.LayoutParams(-1, -2);
        skipAuthParams.gravity = 81;
        skipAuthParams.weight = 1.0f;
        if (this.displayUtils != null) {
            skipAuthParams.setMargins(0, this.displayUtils.getDIP(30), 0, 0);
        }
        this.skipAuth = new TextView(this.getContext());
        this.skipAuth.setTextSize(1, 14.0f);
        if (this.colors != null) {
            this.skipAuth.setTextColor(this.colors.getColor("ANON_CELL_TITLE"));
        }
        this.skipAuth.setGravity(81);
        this.skipAuth.setPadding(0, 0, 0, this.padding);
        this.skipAuth.setLayoutParams((ViewGroup.LayoutParams)skipAuthParams);
        if (this.rememberCell != null) {
            contentLayout.addView((View)this.rememberCell);
        }
        contentLayout.addView((View)this.skipAuth);
        container.addView((View)contentLayout);
        this.addView(header);
        this.addView((View)container);
    }

    public void setAuthRequired(boolean required) {
        if (!required) {
            if (this.rememberCell != null) {
                this.rememberCell.setVisibility(0);
            }
            String mystring = this.localizationService.getString("socialize_auth_rathernot");
            SpannableString content = new SpannableString((CharSequence)mystring);
            content.setSpan((Object)new UnderlineSpan(), 0, mystring.length(), 0);
            this.skipAuth.setText((CharSequence)content);
            this.skipAuth.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AuthPanelView.this.rememberCell != null && AuthPanelView.this.rememberCell.isToggled()) {
                        UserSettings settings = AuthPanelView.this.getSocialize().getSession().getUserSettings();
                        settings.setShowAuthDialog(false);
                        AuthPanelView.this.sessionPersister.saveUserSettingsAsync(AuthPanelView.this.getContext(), settings);
                    }
                    if (AuthPanelView.this.authDialogListener != null) {
                        AuthPanelView.this.authDialogListener.onSkipAuth(AuthPanelView.this.getActivity(), AuthPanelView.this.dialog);
                    }
                }
            });
        } else {
            if (this.rememberCell != null) {
                this.rememberCell.setVisibility(8);
            }
            this.skipAuth.setText((CharSequence)this.localizationService.getString("socialize_auth_required"));
        }
    }

    protected View makeShareBadge() {
        RelativeLayout.LayoutParams badgeParams = new RelativeLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams badgeLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        badgeLayoutParams.gravity = 17;
        badgeParams.addRule(13);
        RelativeLayout badgeLayout = new RelativeLayout(this.getContext());
        badgeLayout.setLayoutParams((ViewGroup.LayoutParams)badgeLayoutParams);
        if (this.drawables != null) {
            ImageView authBadge = new ImageView(this.getContext());
            authBadge.setImageDrawable(this.drawables.getDrawable("auth_badge.png"));
            authBadge.setLayoutParams((ViewGroup.LayoutParams)badgeParams);
            authBadge.setPadding(0, 0, 0, this.padding);
            badgeLayout.addView((View)authBadge);
        }
        return badgeLayout;
    }

    protected void makeAuthButtons() {
        boolean rememberOk;
        LinearLayout.LayoutParams cellParams = new LinearLayout.LayoutParams(-1, -2);
        boolean fbOK = this.getSocialize().isSupported(this.getContext(), AuthProviderType.FACEBOOK) && this.facebookSignInCellFactory != null;
        boolean twOK = this.getSocialize().isSupported(this.getContext(), AuthProviderType.TWITTER) && this.twitterSignInCellFactory != null;
        boolean bl = rememberOk = this.rememberAuthCellFactory != null && this.config.isAllowNeverAuth();
        if (fbOK) {
            this.facebookSignInCell = (FacebookSignInCell)((Object)this.facebookSignInCellFactory.getBean());
            if (this.facebookSignInCell != null) {
                this.facebookSignInCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.facebookSignInCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                if (twOK) {
                    this.twitterSignInCell = (TwitterSignInCell)((Object)this.twitterSignInCellFactory.getBean());
                    this.twitterSignInCell.setPadding(this.padding, this.padding, this.padding, this.padding);
                    this.twitterSignInCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                    this.facebookSignInCell.setBackgroundData(this.fbRadii, this.fbStroke, -16777216);
                    this.twitterSignInCell.setBackgroundData(this.twRadii, this.twStroke, -16777216);
                }
            }
        } else if (twOK) {
            this.twitterSignInCell = (TwitterSignInCell)((Object)this.twitterSignInCellFactory.getBean());
            if (this.twitterSignInCell != null) {
                this.twitterSignInCell.setLayoutParams((ViewGroup.LayoutParams)cellParams);
                this.twitterSignInCell.setPadding(this.padding, this.padding, this.padding, this.padding);
            }
        }
        if (this.facebookSignInCell != null) {
            this.facebookSignInCell.setAuthListener(this.getAuthClickListener(this.facebookSignInCell, SocialNetwork.FACEBOOK));
        }
        if (this.twitterSignInCell != null) {
            this.twitterSignInCell.setAuthListener(this.getAuthClickListener(this.twitterSignInCell, SocialNetwork.TWITTER));
        }
        if (rememberOk) {
            this.rememberCell = (RememberCell)((Object)this.rememberAuthCellFactory.getBean());
            if (this.rememberCell != null) {
                LinearLayout.LayoutParams rememberCellParams = new LinearLayout.LayoutParams(-1, -2);
                rememberCellParams.setMargins(0, this.padding, 0, 0);
                this.rememberCell.setLayoutParams((ViewGroup.LayoutParams)rememberCellParams);
            }
        }
        if (this.anonCellFactory != null) {
            this.anonymousCell = (AnonymousCell)((Object)this.anonCellFactory.getBean());
            if (this.anonymousCell != null) {
                LinearLayout.LayoutParams anonCellParams = new LinearLayout.LayoutParams(-1, -2);
                anonCellParams.setMargins(0, this.padding, 0, 0);
                this.anonymousCell.setLayoutParams((ViewGroup.LayoutParams)anonCellParams);
            }
        }
    }

    protected View makeHeaderView(int headerHeight, float headerRadius) {
        LinearLayout.LayoutParams headerParams = new LinearLayout.LayoutParams(-1, headerHeight);
        TextView header = new TextView(this.getContext());
        if (this.colors != null) {
            GradientDrawable headerBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("AUTH_PANEL_BOTTOM"), this.colors.getColor("AUTH_PANEL_TOP")});
            headerBG.setCornerRadii(new float[]{headerRadius, headerRadius, headerRadius, headerRadius, 0.0f, 0.0f, 0.0f, 0.0f});
            CompatUtils.setBackgroundDrawable((View)header, (Drawable)headerBG);
        }
        if (this.localizationService != null) {
            header.setText((CharSequence)this.localizationService.getString("socialize_auth_header"));
        }
        header.setTextSize(1, 18.0f);
        header.setTextColor(-1);
        header.setGravity(17);
        header.setLayoutParams((ViewGroup.LayoutParams)headerParams);
        return header;
    }

    public void setFacebookSignInCellFactory(IBeanFactory<FacebookSignInCell> facebookSignInCellFactory) {
        this.facebookSignInCellFactory = facebookSignInCellFactory;
    }

    public void setTwitterSignInCellFactory(IBeanFactory<TwitterSignInCell> twitterSignInCellFactory) {
        this.twitterSignInCellFactory = twitterSignInCellFactory;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public FacebookSignInCell getFacebookSignInCell() {
        return this.facebookSignInCell;
    }

    public TwitterSignInCell getTwitterSignInCell() {
        return this.twitterSignInCell;
    }

    public void setAuthDialogListener(AuthDialogListener authDialogListener) {
        this.authDialogListener = authDialogListener;
    }

    public void setAnonCellFactory(IBeanFactory<AnonymousCell> anonCellFactory) {
        this.anonCellFactory = anonCellFactory;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setRememberAuthCellFactory(IBeanFactory<RememberCell> rememberAuthCellFactory) {
        this.rememberAuthCellFactory = rememberAuthCellFactory;
    }

    public void setSessionPersister(SocializeSessionPersister sessionPersister) {
        this.sessionPersister = sessionPersister;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected SocializeAuthListener getAuthClickListener(ClickableSectionCell cell, final SocialNetwork network) {
        return new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                SocializeLogger.e(error.getMessage(), error);
                AuthPanelView.this.showErrorToast(AuthPanelView.this.getContext(), error);
                if (AuthPanelView.this.authDialogListener != null) {
                    AuthPanelView.this.authDialogListener.onError(AuthPanelView.this.getActivity(), AuthPanelView.this.dialog, error);
                }
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                if (AuthPanelView.this.authDialogListener != null) {
                    AuthPanelView.this.authDialogListener.onAuthenticate(AuthPanelView.this.getActivity(), AuthPanelView.this.dialog, network);
                }
            }

            @Override
            public void onAuthFail(SocializeException error) {
                SocializeLogger.e(error.getMessage(), error);
                AuthPanelView.this.showErrorToast(AuthPanelView.this.getContext(), error);
                if (AuthPanelView.this.authDialogListener != null) {
                    AuthPanelView.this.authDialogListener.onError(AuthPanelView.this.getActivity(), AuthPanelView.this.dialog, error);
                }
            }

            @Override
            public void onCancel() {
                if (AuthPanelView.this.authDialogListener != null) {
                    AuthPanelView.this.authDialogListener.onCancel(AuthPanelView.this.dialog);
                }
            }
        };
    }
}

