/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;
import com.socialize.ui.view.SafeViewFlipper;
import com.socialize.util.DisplayUtils;

public class ActionBarItem
extends LinearLayout {
    public static final int DEFAULT_TEXT_COLOR = -1;
    private Drawable icon;
    private String text;
    private float textSize = -1.0f;
    private Integer textColor;
    private ImageView imageView;
    private TextView textView;
    private DisplayUtils displayUtils;
    private boolean invertProgressStyle = false;
    private ViewFlipper iconFlipper;

    public ActionBarItem(Context context) {
        super(context);
    }

    public ActionBarItem(Context context, int textColor) {
        super(context);
        this.textColor = textColor;
    }

    public void init() {
        int leftMargin = this.displayUtils.getDIP(6);
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, -1);
        masterParams.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        int style = 16842873;
        if (this.invertProgressStyle) {
            style = 16843400;
        }
        ProgressBar progress = new ProgressBar(this.getContext(), null, style);
        RelativeLayout progressLayout = new RelativeLayout(this.getContext());
        int minWidth = this.displayUtils.getDIP(24);
        int minHeight = this.displayUtils.getDIP(24);
        if (this.icon != null) {
            int intrinsicWidth = this.icon.getMinimumWidth();
            int intrinsicHeight = this.icon.getMinimumHeight();
            if (intrinsicWidth > minWidth) {
                minWidth = intrinsicWidth;
            }
            if (intrinsicHeight > minHeight) {
                minHeight = intrinsicHeight;
            }
        }
        progressLayout.setMinimumWidth(minWidth += leftMargin);
        progressLayout.setMinimumHeight(minHeight);
        LinearLayout.LayoutParams progressLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        progressLayoutParams.gravity = 17;
        progressLayoutParams.setMargins(leftMargin, 0, 0, 0);
        RelativeLayout.LayoutParams progressParams = new RelativeLayout.LayoutParams(-2, -2);
        progressParams.addRule(13);
        progressParams.addRule(15);
        progressLayout.setLayoutParams((ViewGroup.LayoutParams)progressLayoutParams);
        progress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
        progressLayout.addView((View)progress);
        RelativeLayout imageLayout = new RelativeLayout(this.getContext());
        imageLayout.setMinimumWidth(minWidth);
        imageLayout.setMinimumHeight(minHeight);
        LinearLayout.LayoutParams imageLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        imageLayoutParams.gravity = 17;
        imageLayoutParams.setMargins(leftMargin, 0, 0, 0);
        imageLayout.setLayoutParams((ViewGroup.LayoutParams)imageLayoutParams);
        this.imageView = new ImageView(this.getContext());
        RelativeLayout.LayoutParams iconParams = new RelativeLayout.LayoutParams(-2, -2);
        iconParams.addRule(13);
        if (this.icon != null) {
            this.imageView.setImageDrawable(this.icon);
        }
        this.imageView.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        imageLayout.addView((View)this.imageView);
        LinearLayout textLayout = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams textLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        textLayoutParams.gravity = 19;
        textLayoutParams.setMargins(0, 0, 0, 0);
        textLayout.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
        this.textView = new TextView(this.getContext());
        this.textView.setSingleLine(true);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-2, -2);
        textParams.gravity = 19;
        if (this.text != null) {
            this.textView.setText((CharSequence)this.text);
        }
        if (this.textSize > 0.0f) {
            this.textView.setTextSize(2, this.textSize);
        } else {
            this.textView.setTextSize(1, 11.0f);
        }
        this.textView.setTypeface(Typeface.DEFAULT_BOLD);
        this.textView.setTextColor(this.textColor == null ? -1 : this.textColor);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)textParams);
        textLayout.addView((View)this.textView);
        LinearLayout.LayoutParams flipperParams = new LinearLayout.LayoutParams(-2, -2);
        flipperParams.gravity = 17;
        this.iconFlipper = new SafeViewFlipper(this.getContext());
        this.iconFlipper.setLayoutParams((ViewGroup.LayoutParams)flipperParams);
        this.iconFlipper.addView((View)imageLayout, 0);
        this.iconFlipper.addView((View)progressLayout, 1);
        this.iconFlipper.setDisplayedChild(0);
        this.addView((View)this.iconFlipper);
        this.addView((View)textLayout);
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setIcon(Drawable icon) {
        this.icon = icon;
        if (this.imageView != null) {
            this.imageView.setImageDrawable(icon);
        }
    }

    public void setTextSize(float size) {
        this.textSize = size;
        if (this.textView != null) {
            this.textView.setTextSize(size);
        }
    }

    public void setTextColor(int color) {
        this.textColor = color;
        if (this.textView != null) {
            this.textView.setTextColor(color);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.textView != null) {
            this.textView.setText((CharSequence)text);
        }
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public void setInvertProgressStyle(boolean invertProgressStyle) {
        this.invertProgressStyle = invertProgressStyle;
    }

    public void showLoading() {
        if (this.iconFlipper != null) {
            this.iconFlipper.setDisplayedChild(1);
        }
    }

    public void hideLoading() {
        if (this.iconFlipper != null) {
            this.iconFlipper.setDisplayedChild(0);
        }
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public TextView getTextView() {
        return this.textView;
    }
}

