/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.ui.actionbar.ActionBarButtonListener;
import com.socialize.ui.actionbar.ActionBarItem;
import com.socialize.util.DisplayUtils;

public class ActionBarButton
extends LinearLayout {
    private Drawable icon;
    private String text;
    private ActionBarButtonListener listener;
    private DisplayUtils displayUtils;
    private ActionBarItem actionBarItem;
    private IBeanFactory<ActionBarItem> actionBarItemFactory;

    public ActionBarButton(Context context) {
        super(context);
    }

    public void init(int width, float weight, Integer textColor) {
        if (width > 0) {
            width = this.displayUtils.getDIP(width);
        }
        int height = this.displayUtils.getDIP(44);
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(width, height);
        masterParams.gravity = 17;
        masterParams.weight = weight;
        this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        this.actionBarItem = (ActionBarItem)((Object)this.actionBarItemFactory.getBean(new Object[]{textColor}));
        this.actionBarItem.setIcon(this.icon);
        this.actionBarItem.setText(this.text);
        this.actionBarItem.init();
        this.addView((View)this.actionBarItem);
        if (this.listener != null) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ActionBarButton.this.listener.onClick(ActionBarButton.this);
                }
            });
        }
    }

    public void setIcon(Drawable icon) {
        this.icon = icon;
        if (this.actionBarItem != null) {
            this.actionBarItem.setIcon(icon);
        }
    }

    public void setListener(ActionBarButtonListener listener) {
        this.listener = listener;
    }

    public void setText(String text) {
        this.text = text;
        if (this.actionBarItem != null) {
            this.actionBarItem.setText(text);
        }
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public ActionBarItem getActionBarItem() {
        return this.actionBarItem;
    }

    public void setActionBarItemFactory(IBeanFactory<ActionBarItem> itemFactory) {
        this.actionBarItemFactory = itemFactory;
    }

    public void showLoading() {
        if (this.actionBarItem != null) {
            this.actionBarItem.showLoading();
        }
    }

    public void hideLoading() {
        if (this.actionBarItem != null) {
            this.actionBarItem.hideLoading();
        }
    }
}

