/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.action;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.socialize.CommentUtils;
import com.socialize.UserUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.Comment;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.comment.CommentGetListener;
import com.socialize.listener.user.UserGetListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.action.ActionDetailContentView;
import com.socialize.ui.action.OnActionDetailViewListener;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.ui.image.ImageLoadListener;
import com.socialize.ui.image.ImageLoadRequest;
import com.socialize.ui.image.ImageLoader;
import com.socialize.util.Drawables;
import com.socialize.util.SafeBitmapDrawable;
import com.socialize.util.StringUtils;
import com.socialize.view.BaseView;

public class ActionDetailLayoutView
extends BaseView {
    private String userId;
    private String actionId;
    private ProgressDialog dialog = null;
    private Drawable defaultProfilePicture;
    private SocializeAction currentAction;
    private ActionDetailContentView content;
    private OnActionDetailViewListener onActionDetailViewListener;
    private User currentUser;
    private int count = 0;
    private Drawables drawables;
    private IBeanFactory<ActionDetailContentView> actionDetailContentViewFactory;
    private ProgressDialogFactory progressDialogFactory;
    private ImageLoader imageLoader;
    private ListenerHolder listenerHolder;

    public ActionDetailLayoutView(Activity context, String userId) {
        this((Context)context);
        this.userId = userId;
        if (this.userId != null) {
            this.userId = this.userId.trim();
        }
    }

    public ActionDetailLayoutView(Activity context, String userId, String actionId) {
        this(context, userId);
        this.actionId = actionId;
    }

    public ActionDetailLayoutView(Context context) {
        super(context);
    }

    public void init() {
        LinearLayout.LayoutParams fill = new LinearLayout.LayoutParams(-1, -1);
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)fill);
        this.setPadding(0, 0, 0, 0);
        this.setVerticalFadingEdgeEnabled(false);
        this.content = (ActionDetailContentView)this.actionDetailContentViewFactory.getBean();
        this.defaultProfilePicture = this.drawables.getDrawable("default_user_icon.png");
        this.onActionDetailViewListener = (OnActionDetailViewListener)this.listenerHolder.pop("action_view");
        this.addView((View)this.content);
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        if (this.onActionDetailViewListener != null) {
            this.onActionDetailViewListener.onCreate(this);
        }
        this.reload();
    }

    @Override
    public void onViewRendered(int width, int height) {
        super.onViewRendered(width, height);
        if (this.onActionDetailViewListener != null) {
            this.onActionDetailViewListener.onRender(this);
        }
    }

    public void reload() {
        if (this.getSocialize().isAuthenticated()) {
            this.dialog = this.progressDialogFactory.show(this.getContext(), "socialize_loading", "socialize_please_wait");
            this.count = 1;
            this.doGetAction();
        } else {
            this.showError(this.getContext(), new SocializeException("Socialize not authenticated"));
        }
    }

    protected void countdown() {
        --this.count;
        if (this.count <= 0) {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
            this.count = 0;
        }
    }

    public void doGetAction() {
        if (!(StringUtils.isEmpty(this.actionId) || this.currentAction != null && this.currentAction.getId().equals(this.actionId))) {
            int id = Integer.parseInt(this.actionId);
            CommentUtils.getComment(this.getActivity(), new CommentGetListener(){

                @Override
                public void onError(SocializeException error) {
                    ActionDetailLayoutView.this.countdown();
                    ActionDetailLayoutView.this.showError(ActionDetailLayoutView.this.getContext(), error);
                }

                @Override
                public void onGet(Comment entity) {
                    ActionDetailLayoutView.this.currentAction = entity;
                    ActionDetailLayoutView.this.content.setAction(entity);
                    if (entity.getUser() != null) {
                        ActionDetailLayoutView.this.doGetUserProfile(entity.getUser().getId(), entity);
                    } else if (!StringUtils.isEmpty(ActionDetailLayoutView.this.userId)) {
                        ActionDetailLayoutView.this.doGetUserProfile(Long.parseLong(ActionDetailLayoutView.this.userId), entity);
                    }
                }
            }, id);
        } else if (!StringUtils.isEmpty(this.userId)) {
            this.doGetUserProfile(Long.parseLong(this.userId), null);
        }
    }

    protected void doGetUserProfile(SocializeAction action) {
        if (action != null && action.getUser() != null) {
            this.doGetUserProfile(action.getUser().getId(), action);
        } else if (!StringUtils.isEmpty(this.userId)) {
            this.doGetUserProfile(Long.parseLong(this.userId), action);
        }
    }

    protected void doGetUserProfile(long userId, final SocializeAction action) {
        if (!(userId < 0L || this.currentUser != null && this.currentUser.getId().equals(userId))) {
            UserUtils.getUser((Context)this.getActivity(), userId, new UserGetListener(){

                @Override
                public void onGet(User user) {
                    ActionDetailLayoutView.this.currentUser = user;
                    ActionDetailLayoutView.this.setUserDetails(user, action);
                    ActionDetailLayoutView.this.countdown();
                }

                @Override
                public void onError(SocializeException error) {
                    ActionDetailLayoutView.this.countdown();
                    ActionDetailLayoutView.this.showError(ActionDetailLayoutView.this.getContext(), error);
                }
            });
        } else {
            this.countdown();
        }
    }

    public void setUserDetails(User user, SocializeAction action) {
        String profilePicData = user.getSmallImageUri();
        final ImageView userIcon = this.content.getProfilePicture();
        if (!StringUtils.isEmpty(profilePicData)) {
            userIcon.getBackground().setAlpha(64);
            this.imageLoader.loadImageByUrl(profilePicData, new ImageLoadListener(){

                @Override
                public void onImageLoadFail(ImageLoadRequest request, Exception error) {
                    SocializeLogger.e(error.getMessage(), error);
                    userIcon.post(new Runnable(){

                        @Override
                        public void run() {
                            userIcon.setImageDrawable(ActionDetailLayoutView.this.defaultProfilePicture);
                            userIcon.getBackground().setAlpha(255);
                        }
                    });
                }

                @Override
                public void onImageLoad(ImageLoadRequest request, final SafeBitmapDrawable drawable2) {
                    userIcon.post(new Runnable(){

                        @Override
                        public void run() {
                            drawable2.setAlpha(255);
                            userIcon.setImageDrawable((Drawable)drawable2);
                            userIcon.getBackground().setAlpha(255);
                        }
                    });
                }
            });
        } else {
            userIcon.setImageDrawable(this.defaultProfilePicture);
            userIcon.getBackground().setAlpha(255);
        }
        this.content.getDisplayName().setText((CharSequence)user.getDisplayName());
        this.content.loadUserActivity(user, action);
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setUserId(String entityKey) {
        this.userId = entityKey;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public void setProgressDialogFactory(ProgressDialogFactory progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }

    public void setActionDetailContentViewFactory(IBeanFactory<ActionDetailContentView> actionDetailContentViewFactory) {
        this.actionDetailContentViewFactory = actionDetailContentViewFactory;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public SocializeAction getCurrentAction() {
        return this.currentAction;
    }

    public void onProfileUpdate() {
        this.dialog = this.progressDialogFactory.show(this.getContext(), "socialize_loading", "socialize_please_wait");
        this.count = 1;
        this.currentUser = null;
        this.doGetUserProfile(this.currentAction);
    }

    public ActionDetailContentView getContent() {
        return this.content;
    }
}

