/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.action;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import com.socialize.CommentUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.ui.SocializeUIActivity;
import com.socialize.ui.action.ActionDetailView;

public class ActionDetailActivity
extends SocializeUIActivity {
    private ActionDetailView view;

    @Override
    protected void onCreateSafe(Bundle savedInstanceState) {
        Intent intent = this.getIntent();
        this.doActivityLoad(intent);
    }

    @Override
    protected void onNewIntentSafe(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null && this.view != null) {
            this.view.reload(extras.getString("socialize.user.id"), extras.getString("socialize.action.id"));
        }
    }

    protected void doActivityLoad(Intent intent) {
        SocializeSession session = this.getSocialize().getSession();
        if (session == null) {
            this.finish();
        } else {
            User user = session.getUser();
            if (user == null) {
                this.finish();
            } else {
                this.view = new ActionDetailView((Context)this);
                this.setContentView((View)this.view);
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == 1347) {
            this.view.onProfileUpdate();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        SocializeAction currentAction;
        if (keyCode == 4 && this.isTaskRoot() && this.view != null && (currentAction = this.view.getCurrentAction()) != null) {
            CommentUtils.showCommentView(this, currentAction.getEntity());
            this.finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.view != null) {
            return this.view.onCreateOptionsMenu(this, menu);
        }
        return false;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }
}

