/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.AsyncTask;
import android.os.Parcelable;
import android.util.Log;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.android.ioc.Logger;
import com.socialize.api.DeviceRegistrationSystem;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.user.UserSystem;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.DeviceRegistration;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationRegistrationState;
import com.socialize.notifications.NotificationRegistrationSystem;
import com.socialize.util.StringUtils;
import java.util.List;

public class SocializeNotificationRegistrationSystem
implements NotificationRegistrationSystem {
    public static final String EXTRA_SENDER = "sender";
    public static final String EXTRA_APPLICATION_PENDING_INTENT = "app";
    public static final String REQUEST_UNREGISTRATION_INTENT = "com.google.android.c2dm.intent.UNREGISTER";
    public static final String REQUEST_REGISTRATION_INTENT = "com.google.android.c2dm.intent.REGISTER";
    private SocializeConfig config;
    private SocializeLogger logger;
    private DeviceRegistrationSystem deviceRegistrationSystem;
    private UserSystem userSystem;
    private IBeanFactory<DeviceRegistration> deviceRegistrationFactory;
    private NotificationRegistrationState notificationRegistrationState;

    @Override
    public boolean isRegistrationPending() {
        return this.notificationRegistrationState.isC2dmPending();
    }

    @Override
    public boolean isRegisteredC2DM(Context context) {
        return this.notificationRegistrationState.isRegisteredC2DM(context);
    }

    @Override
    public boolean isSocializeRegistrationPending() {
        return this.notificationRegistrationState.isSocializeRegistrationPending();
    }

    @Override
    public boolean isRegisteredSocialize(Context context, User user) {
        return this.notificationRegistrationState.isRegisteredSocialize(context, user);
    }

    @Override
    public void registerC2DMFailed(Context context, String cause) {
        this.notificationRegistrationState.setC2dmPendingRequestTime(0L);
    }

    @Override
    public void registerC2DMAsync(final Context context) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    SocializeNotificationRegistrationSystem.this.registerC2DM(context);
                }
                catch (Exception e) {
                    if (SocializeNotificationRegistrationSystem.this.logger != null) {
                        SocializeNotificationRegistrationSystem.this.logger.error("Error during smart alert registration", (Throwable)e);
                    }
                    Log.e((String)Logger.LOG_KEY, (String)"Error during smart alert registration", (Throwable)e);
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    @Override
    public synchronized void registerC2DM(Context context) {
        if (!this.isRegisteredC2DM(context) && !this.notificationRegistrationState.isC2dmPending() && this.config.getBooleanProperty("gcm.registration.enabled", true)) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Registering with GCM");
            }
            this.notificationRegistrationState.setC2dmPendingRequestTime(System.currentTimeMillis());
            String senderId = this.config.getProperty("socialize.gcm.sender.id", this.config.getProperty("socialize.c2dm.sender.id"));
            String customSender = this.config.getProperty("socialize.custom.gcm.sender.id");
            if (!(StringUtils.isEmpty(senderId) || StringUtils.isEmpty(customSender) || senderId.equals(customSender))) {
                senderId = senderId + "," + customSender;
            }
            Intent implicitIntent = this.newIntent(REQUEST_REGISTRATION_INTENT);
            PackageManager pm = context.getPackageManager();
            List resolveInfos = pm.queryIntentServices(implicitIntent, 0);
            if (resolveInfos != null && resolveInfos.size() > 1) {
                ResolveInfo serviceInfo = (ResolveInfo)resolveInfos.get(0);
                String packageName = serviceInfo.serviceInfo.packageName;
                String className = serviceInfo.serviceInfo.name;
                ComponentName component = new ComponentName(packageName, className);
                Intent registrationIntent = this.newIntent(implicitIntent);
                registrationIntent.setComponent(component);
                registrationIntent.putExtra(EXTRA_APPLICATION_PENDING_INTENT, (Parcelable)this.newPendingIntent(context));
                registrationIntent.putExtra(EXTRA_SENDER, senderId);
                context.startService(registrationIntent);
            }
        } else if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("GCM registration already in progress, complete or disabled");
        }
    }

    @Override
    public void registerSocialize(Context context, String registrationId) {
        this.notificationRegistrationState.setPendingSocializeRequestTime(System.currentTimeMillis());
        this.notificationRegistrationState.save(context);
        if (!StringUtils.isEmpty(registrationId)) {
            try {
                SocializeSession session = this.userSystem.authenticateSynchronous(context, this.config.getProperty("socialize.consumer.key"), this.config.getProperty("socialize.consumer.secret"));
                this.doRegistrationSocialize(context, session, registrationId);
            }
            catch (SocializeException e) {
                this.logError(e);
            }
        }
    }

    protected void doRegistrationSocialize(Context context, SocializeSession session, String registrationId) {
        block3: {
            DeviceRegistration registration = (DeviceRegistration)this.deviceRegistrationFactory.getBean();
            registration.setRegistrationId(registrationId);
            try {
                this.deviceRegistrationSystem.registerDeviceSynchronous(session, registration);
                this.notificationRegistrationState.setC2DMRegistrationId(registrationId);
                this.notificationRegistrationState.setRegisteredSocialize(session.getUser());
                this.notificationRegistrationState.save(context);
                if (this.logger != null && this.logger.isInfoEnabled()) {
                    this.logger.info("Registration with Socialize for GCM successful.");
                }
            }
            catch (SocializeException e) {
                if (this.logger == null) break block3;
                this.logger.error("Error registering device with Socialize.  Will retry on next start", (Throwable)e);
            }
        }
    }

    protected void logError(Exception e) {
        if (this.logger != null) {
            this.logger.error("Error during device registration", (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    protected Intent newIntent(String action) {
        return new Intent(action);
    }

    protected Intent newIntent(Intent intent) {
        return new Intent(intent);
    }

    protected PendingIntent newPendingIntent(Context context) {
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0);
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setDeviceRegistrationSystem(DeviceRegistrationSystem deviceRegistrationSystem) {
        this.deviceRegistrationSystem = deviceRegistrationSystem;
    }

    public void setNotificationRegistrationState(NotificationRegistrationState notificationRegistrationState) {
        this.notificationRegistrationState = notificationRegistrationState;
    }

    public void setDeviceRegistrationFactory(IBeanFactory<DeviceRegistration> deviceRegistrationFactory) {
        this.deviceRegistrationFactory = deviceRegistrationFactory;
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }
}

