/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.android.ioc.Logger;
import com.socialize.ioc.SocializeIOC;
import com.socialize.log.SocializeLogger;
import com.socialize.util.ClassLoaderProvider;
import com.socialize.util.ResourceLocator;
import java.util.concurrent.CountDownLatch;

public class NotificationContainer {
    private SocializeIOC container;
    static String[] NotificationBeans = new String[]{"socialize_core_beans.xml", "socialize_notification_beans.xml"};

    public void onCreate(final Context context) throws Exception {
        Logger.LOG_KEY = "Socialize";
        Logger.logLevel = 5;
        this.container = this.newSocializeIOC();
        final ResourceLocator locator = this.newResourceLocator();
        final SocializeLogger logger = this.newLogger();
        locator.setLogger(logger);
        ClassLoaderProvider provider = this.newClassLoaderProvider();
        locator.setClassLoaderProvider(provider);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    NotificationContainer.this.container.init(context, locator, NotificationBeans);
                }
                catch (Exception e) {
                    logger.error("Error initializing notification container", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        latch.await();
    }

    public void onDestroy(Context context) {
    }

    public IOCContainer getContainer() {
        return this.container;
    }

    protected SocializeIOC newSocializeIOC() {
        return new SocializeIOC();
    }

    protected ResourceLocator newResourceLocator() {
        return new ResourceLocator();
    }

    protected SocializeLogger newLogger() {
        return new SocializeLogger();
    }

    protected ClassLoaderProvider newClassLoaderProvider() {
        return new ClassLoaderProvider();
    }
}

