/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.WakeLock;
import com.socialize.util.StringUtils;

public abstract class BaseC2DMReceiver
extends IntentService {
    public static final String C2DM_RETRY = "com.google.android.c2dm.intent.RETRY";
    public static final String REGISTRATION_CALLBACK_INTENT = "com.google.android.c2dm.intent.REGISTRATION";
    public static final String C2DM_INTENT = "com.google.android.c2dm.intent.RECEIVE";
    public static final String EXTRA_UNREGISTERED = "unregistered";
    public static final String EXTRA_ERROR = "error";
    public static final String EXTRA_REGISTRATION_ID = "registration_id";
    public static final String ERR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERR_ACCOUNT_MISSING = "ACCOUNT_MISSING";
    public static final String ERR_AUTHENTICATION_FAILED = "AUTHENTICATION_FAILED";
    public static final String ERR_TOO_MANY_REGISTRATIONS = "TOO_MANY_REGISTRATIONS";
    public static final String ERR_INVALID_PARAMETERS = "INVALID_PARAMETERS";
    public static final String ERR_INVALID_SENDER = "INVALID_SENDER";
    public static final String ERR_PHONE_REGISTRATION_ERROR = "PHONE_REGISTRATION_ERROR";

    public BaseC2DMReceiver(String name) {
        super(name);
    }

    protected abstract void onMessage(Context var1, Intent var2);

    protected abstract void onError(Context var1, String var2);

    protected abstract void onRegistrered(Context var1, String var2);

    protected abstract void onUnregistered(Context var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandleIntent(Intent intent) {
        Context context = this.getApplicationContext();
        if (intent != null) {
            try {
                String action = intent.getAction();
                if (!StringUtils.isEmpty(action)) {
                    if (this.isRegistrationAction(action)) {
                        this.onRegistrationResponse(context, intent);
                    } else if (this.isMessageAction(action)) {
                        this.onMessage(context, intent);
                    }
                }
            }
            catch (Exception e) {
                SocializeLogger.e(e.getMessage(), e);
            }
            finally {
                WakeLock.getInstance().release(context);
            }
        }
    }

    protected boolean isRegistrationAction(String action) {
        return action.equals(REGISTRATION_CALLBACK_INTENT);
    }

    protected boolean isMessageAction(String action) {
        return action.equals(C2DM_INTENT);
    }

    protected void onRegistrationResponse(Context context, Intent intent) {
        String registrationId = intent.getStringExtra(EXTRA_REGISTRATION_ID);
        String error = intent.getStringExtra(EXTRA_ERROR);
        String removed = intent.getStringExtra(EXTRA_UNREGISTERED);
        if (!StringUtils.isEmpty(removed)) {
            this.onUnregistered(context);
        } else if (!StringUtils.isEmpty(error)) {
            this.onError(context, error);
        } else if (!StringUtils.isEmpty(registrationId)) {
            this.onRegistrered(context, registrationId);
        } else {
            this.onError(context, "No registration ID in response from GCM");
        }
    }
}

