/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import com.facebook.HttpMethod;
import com.socialize.ConfigUtils;
import com.socialize.ShareUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.api.action.user.UserSystem;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderResponse;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.facebook.FacebookActivity;
import com.socialize.auth.facebook.FacebookAuthProviderInfo;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.error.SocializeException;
import com.socialize.listener.AuthProviderListener;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.DefaultPostData;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.SocializeDeAuthListener;
import com.socialize.networks.facebook.FacebookFacade;
import com.socialize.networks.facebook.OnPermissionResult;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.ArrayUtils;
import com.socialize.util.ImageUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseFacebookFacade
implements FacebookFacade {
    protected ListenerHolder holder;
    protected UserSystem userSystem;
    protected SocializeLogger logger;
    protected SocializeConfig config;
    protected ImageUtils imageUtils;

    @Override
    public void authenticateWithActivity(Activity context, FacebookAuthProviderInfo info, boolean sso, final AuthProviderListener listener) {
        String listenerKey = "auth";
        this.holder.push("auth", new AuthProviderListener(){

            @Override
            public void onError(SocializeException error) {
                BaseFacebookFacade.this.holder.remove("auth");
                listener.onError(error);
            }

            @Override
            public void onAuthSuccess(AuthProviderResponse response) {
                BaseFacebookFacade.this.holder.remove("auth");
                listener.onAuthSuccess(response);
            }

            @Override
            public void onAuthFail(SocializeException error) {
                BaseFacebookFacade.this.holder.remove("auth");
                listener.onAuthFail(error);
            }

            @Override
            public void onCancel() {
                BaseFacebookFacade.this.holder.remove("auth");
                listener.onCancel();
            }
        });
        Intent i = new Intent((Context)context, FacebookActivity.class);
        i.putExtra("appId", info.getAppId());
        i.putExtra("sso", sso);
        i.putExtra("type", info.getPermissionType().toString());
        switch (info.getPermissionType()) {
            case READ: {
                if (info.getReadPermissions() == null) break;
                i.putExtra("permissions", info.getReadPermissions());
                break;
            }
            case WRITE: {
                if (info.getWritePermissions() == null) break;
                i.putExtra("permissions", info.getWritePermissions());
            }
        }
        context.startActivity(i);
    }

    @Override
    @Deprecated
    public void link(Activity context, SocializeAuthListener listener) {
        this.linkForWrite(context, listener, new String[0]);
    }

    @Override
    @Deprecated
    public void link(Activity context, SocializeAuthListener listener, String ... permissions) {
        this.getSocialize().authenticate((Context)context, AuthProviderType.FACEBOOK, listener, permissions);
    }

    @Override
    @Deprecated
    public void link(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener) {
        this.doLink(context, token, verifyPermissions, false, listener, DEFAULT_PERMISSIONS);
    }

    @Override
    public void linkForRead(Activity context, SocializeAuthListener listener, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.READ_PERMISSIONS;
        }
        this.getSocialize().authenticateForRead((Context)context, AuthProviderType.FACEBOOK, listener, permissions);
    }

    @Override
    public void linkForWrite(Activity context, SocializeAuthListener listener, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.WRITE_PERMISSIONS;
        }
        this.getSocialize().authenticateForWrite((Context)context, AuthProviderType.FACEBOOK, listener, permissions);
    }

    @Override
    public void linkForRead(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.READ_PERMISSIONS;
        }
        this.doLink(context, token, verifyPermissions, true, listener, permissions);
    }

    @Override
    public void linkForWrite(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.WRITE_PERMISSIONS;
        }
        this.doLink(context, token, verifyPermissions, false, listener, permissions);
    }

    private void doLink(final Activity context, final String token, boolean verifyPermissions, final boolean read, final SocializeAuthListener listener, final String ... permissions) {
        SocializeConfig config = ConfigUtils.getConfig((Context)context);
        final FacebookAuthProviderInfo fbInfo = new FacebookAuthProviderInfo();
        fbInfo.setAppId(config.getProperty("facebook.app.id"));
        if (read) {
            fbInfo.setPermissionType(FacebookAuthProviderInfo.PermissionType.READ);
        } else {
            fbInfo.setPermissionType(FacebookAuthProviderInfo.PermissionType.WRITE);
        }
        final boolean sso = config.getBooleanProperty("facebook.sso.enabled", true);
        if (verifyPermissions) {
            this.getCurrentPermissions(context, token, new OnPermissionResult(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onError(error);
                    }
                }

                @Override
                public void onSuccess(String[] current) {
                    if (read) {
                        fbInfo.setReadPermissions(current);
                    } else {
                        fbInfo.setWritePermissions(current);
                    }
                    String[] required = read ? FacebookFacade.READ_PERMISSIONS : FacebookFacade.WRITE_PERMISSIONS;
                    boolean authRequired = false;
                    for (String permission : required) {
                        if (Arrays.binarySearch(current, permission) >= 0) continue;
                        authRequired = true;
                        break;
                    }
                    if (authRequired) {
                        HashSet<String> allPermissions = new HashSet<String>();
                        allPermissions.addAll(Arrays.asList(permissions));
                        allPermissions.addAll(Arrays.asList(current));
                        allPermissions.addAll(Arrays.asList(required));
                        if (read) {
                            fbInfo.setReadPermissions(allPermissions.toArray(new String[allPermissions.size()]));
                        } else {
                            fbInfo.setWritePermissions(allPermissions.toArray(new String[allPermissions.size()]));
                        }
                        BaseFacebookFacade.this.authenticateWithActivity(context, fbInfo, sso, new AuthProviderListener(){

                            @Override
                            public void onError(SocializeException error) {
                                if (listener != null) {
                                    listener.onError(error);
                                }
                            }

                            @Override
                            public void onCancel() {
                                if (listener != null) {
                                    listener.onCancel();
                                }
                            }

                            @Override
                            public void onAuthSuccess(AuthProviderResponse response) {
                                BaseFacebookFacade.this.doSocializeAuthKnownUser((Context)context, fbInfo, token, listener);
                            }

                            @Override
                            public void onAuthFail(SocializeException error) {
                                if (listener != null) {
                                    listener.onAuthFail(error);
                                }
                            }
                        });
                    } else {
                        BaseFacebookFacade.this.doSocializeAuthKnownUser((Context)context, fbInfo, token, listener);
                    }
                }
            });
        } else {
            if (read) {
                fbInfo.setReadPermissions(permissions);
            } else {
                fbInfo.setWritePermissions(permissions);
            }
            this.doSocializeAuthKnownUser((Context)context, fbInfo, token, listener);
        }
    }

    @Override
    @Deprecated
    public boolean isLinked(Context context) {
        return this.getSocialize().isAuthenticated(AuthProviderType.FACEBOOK);
    }

    @Override
    public boolean isLinkedForRead(Context context, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.READ_PERMISSIONS;
        }
        return this.getSocialize().isAuthenticatedForRead(AuthProviderType.FACEBOOK, permissions);
    }

    @Override
    public boolean isLinkedForWrite(Context context, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.WRITE_PERMISSIONS;
        }
        return this.getSocialize().isAuthenticatedForWrite(AuthProviderType.FACEBOOK, permissions);
    }

    @Override
    public String getAccessToken(Context context) {
        UserProviderCredentials creds = this.getSocialize().getSession().getUserProviderCredentials(AuthProviderType.FACEBOOK);
        if (creds != null) {
            return creds.getAccessToken();
        }
        return null;
    }

    @Override
    public void unlink(final Context context, final SocializeDeAuthListener listener) {
        try {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    block4: {
                        try {
                            SocializeSession session = BaseFacebookFacade.this.getSocialize().getSession();
                            session.clear(AuthProviderType.FACEBOOK);
                            UserSettings userSettings = session.getUserSettings();
                            if (userSettings != null) {
                                userSettings.setAutoPostFacebook(false);
                            }
                            BaseFacebookFacade.this.userSystem.saveSession(context, session);
                            BaseFacebookFacade.this.logout(context);
                            if (listener != null) {
                                listener.onSuccess();
                            }
                        }
                        catch (Exception e) {
                            if (listener == null) break block4;
                            listener.onError(SocializeException.wrap(e));
                        }
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Error while logging out of Facebook", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    @Override
    public void postLike(Activity parent, Entity entity, PropagationInfo propInfo, SocialNetworkListener listener) {
        if (this.config.isOGLike()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("object", propInfo.getEntityUrl());
            this.post(parent, "me/og.likes", params, listener);
        } else {
            this.post(parent, entity, "", propInfo, listener);
        }
    }

    @Override
    public void postEntity(Activity context, Entity entity, String text, SocialNetworkShareListener listener) {
        ShareOptions options = ShareUtils.getUserShareOptions((Context)context);
        options.setText(text);
        options.setShowAuthDialog(false);
        ShareUtils.shareViaSocialNetworks(context, entity, options, listener, SocialNetwork.FACEBOOK);
    }

    @Override
    public void postComment(Activity parent, Entity entity, String comment, PropagationInfo propInfo, SocialNetworkListener listener) {
        this.post(parent, entity, comment, propInfo, listener);
    }

    @Override
    public void postOG(Activity parent, Entity entity, String message, String action, PropagationInfo propInfo, SocialNetworkListener listener) {
        String entityUrl;
        String linkName = entityUrl = propInfo.getEntityUrl();
        String link = entityUrl;
        if (entity != null) {
            linkName = entity.getDisplayName();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", linkName);
        params.put("message", message);
        params.put("link", link);
        params.put("type", "link");
        DefaultPostData postData = new DefaultPostData();
        postData.setPostValues(params);
        postData.setEntity(entity);
        postData.setPropagationInfo(propInfo);
        this.post(parent, listener, postData);
    }

    @Override
    public void post(Activity parent, Entity entity, String message, PropagationInfo propInfo, SocialNetworkListener listener) {
        this.postOG(parent, entity, message, null, propInfo, listener);
    }

    @Override
    public void post(Activity parent, SocialNetworkListener listener, PostData postData) {
        this.doFacebookCall(parent, postData.getPostValues(), "me/links", HttpMethod.POST, (SocialNetworkPostListener)listener);
    }

    @Override
    public void post(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, HttpMethod.POST, listener);
    }

    @Override
    public void get(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, HttpMethod.GET, listener);
    }

    @Override
    public void delete(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, HttpMethod.DELETE, listener);
    }

    protected void doSocializeAuthKnownUser(Context context, AuthProviderInfo fbInfo, String token, SocializeAuthListener listener) {
        DefaultUserProviderCredentials credentials = new DefaultUserProviderCredentials();
        credentials.setAuthProviderInfo(fbInfo);
        credentials.setAccessToken(token);
        this.getSocialize().authenticateKnownUser(context, credentials, listener);
    }

    protected void onError(final Activity parent, String msg, final Throwable e, final SocialNetworkPostListener listener) {
        if (this.logger != null) {
            if (e != null) {
                this.logger.error(msg, e);
            } else {
                this.logger.error(msg);
            }
        } else if (e != null) {
            SocializeLogger.e(msg, e);
        } else {
            System.err.println(msg);
        }
        if (listener != null) {
            parent.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    listener.onNetworkError(parent, SocialNetwork.FACEBOOK, SocializeException.wrap(e));
                }
            });
        }
    }

    protected void handlePermissionError(Activity parent, final OnPermissionResult callback, final Exception e) {
        if (callback != null) {
            parent.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callback.onError(SocializeException.wrap(e));
                }
            });
        }
    }

    protected void handleFacebookError(Activity parent, int code, String msg, Throwable e, SocialNetworkPostListener listener) {
        if (code == 190) {
            this.getSocialize().clear3rdPartySession((Context)parent, AuthProviderType.FACEBOOK);
        }
        this.onError(parent, msg, e, listener);
    }

    protected void doFacebookCall(Activity parent, Map<String, Object> postData, String graphPath, HttpMethod method, SocialNetworkPostListener listener) {
        Bundle bundle = new Bundle();
        if (postData != null) {
            Set<Map.Entry<String, Object>> entries = postData.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value = entry.getValue();
                if (value instanceof byte[]) {
                    bundle.putByteArray(entry.getKey(), (byte[])value);
                    continue;
                }
                bundle.putString(entry.getKey(), value.toString());
            }
        }
        this.doFacebookCall(parent, bundle, graphPath, method, listener);
    }

    protected abstract void doFacebookCall(Activity var1, Bundle var2, String var3, HttpMethod var4, SocialNetworkPostListener var5);

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    protected String getFacebookAppId() {
        return this.config.getProperty("facebook.app.id");
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setImageUtils(ImageUtils imageUtils) {
        this.imageUtils = imageUtils;
    }

    public void setHolder(ListenerHolder holder) {
        this.holder = holder;
    }
}

