/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.net;

import com.socialize.android.ioc.IBeanFactory;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.net.HttpClientFactory;
import com.socialize.net.IdleConnectionMonitorThread;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private HttpParams params;
    private ClientConnectionManager connectionManager;
    private SocializeLogger logger;
    private IBeanFactory<DefaultHttpClient> apacheHttpClientFactory;
    private DefaultHttpClient client;
    private IdleConnectionMonitorThread monitor;
    private boolean destroyed = false;

    @Override
    public void init(SocializeConfig config) throws SocializeException {
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing " + this.getClass().getSimpleName());
            }
            this.params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)this.params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)this.params, (String)"UTF-8");
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.params, (int)config.getIntProperty("http.connection.timeout", 10000));
            HttpConnectionParams.setSoTimeout((HttpParams)this.params, (int)config.getIntProperty("http.socket.timeout", 10000));
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            this.connectionManager = new ThreadSafeClientConnManager(this.params, registry);
            this.monitor = new IdleConnectionMonitorThread(this.connectionManager);
            this.monitor.setDaemon(true);
            this.monitor.start();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Initialized " + this.getClass().getSimpleName());
            }
            this.destroyed = false;
        }
        catch (Exception e) {
            throw new SocializeException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying " + this.getClass().getSimpleName());
        }
        if (this.monitor != null) {
            this.monitor.shutdown();
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Destroyed " + this.getClass().getSimpleName());
        }
        this.destroyed = true;
    }

    @Override
    public synchronized HttpClient getClient() {
        if (this.client == null) {
            this.client = this.apacheHttpClientFactory != null ? (DefaultHttpClient)this.apacheHttpClientFactory.getBean(new Object[]{this.connectionManager, this.params}) : new DefaultHttpClient(this.connectionManager, this.params);
        } else {
            this.monitor.trigger();
        }
        return this.client;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setApacheHttpClientFactory(IBeanFactory<DefaultHttpClient> apacheHttpClientFactory) {
        this.apacheHttpClientFactory = apacheHttpClientFactory;
    }
}

