/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.log;

import android.content.Context;
import com.socialize.log.SDCardExternalLogger;
import com.socialize.log.SocializeLogger;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AsyncSDCardExternalLogger
extends SDCardExternalLogger
implements Runnable {
    private Thread logger = null;
    private Queue<LogJob> jobs = new ConcurrentLinkedQueue<LogJob>();
    private boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            LogJob job = this.jobs.poll();
            while (job != null) {
                super.log(job.level, job.time, job.tag, job.message);
                job = this.jobs.poll();
            }
            AsyncSDCardExternalLogger asyncSDCardExternalLogger = this;
            synchronized (asyncSDCardExternalLogger) {
                if (this.running) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(SocializeLogger.LogLevel level, long time, String tag, String message) {
        LogJob job = new LogJob();
        job.level = level;
        job.time = time;
        job.tag = tag;
        job.message = message;
        this.jobs.add(job);
        AsyncSDCardExternalLogger asyncSDCardExternalLogger = this;
        synchronized (asyncSDCardExternalLogger) {
            this.notify();
        }
    }

    @Override
    public void init(Context context) {
        this.destroy();
        super.init(context);
        this.logger = new Thread((Runnable)this, "AsyncSDCardExternalLogger");
        this.logger.setDaemon(true);
        this.logger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        AsyncSDCardExternalLogger asyncSDCardExternalLogger = this;
        synchronized (asyncSDCardExternalLogger) {
            this.running = false;
            this.notify();
        }
        super.destroy();
    }

    final class LogJob {
        SocializeLogger.LogLevel level;
        long time;
        String tag;
        String message;

        LogJob() {
        }
    }
}

