/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.listener;

import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeEntityResponse;
import com.socialize.api.SocializeResponse;
import com.socialize.entity.ListResult;
import com.socialize.entity.SocializeObject;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeActionListener;

public abstract class AbstractSocializeListener<T extends SocializeObject>
implements SocializeActionListener {
    @Override
    public void onResult(SocializeApi.RequestType type, SocializeResponse response) {
        SocializeEntityResponse entityResponse = (SocializeEntityResponse)response;
        switch (type) {
            case GET: {
                this.onGet((SocializeObject)entityResponse.getFirstResult());
                break;
            }
            case LIST_AS_GET: {
                this.onGet((SocializeObject)entityResponse.getFirstResult());
                break;
            }
            case LIST: {
                this.onList(entityResponse.getResults());
                break;
            }
            case LIST_WITHOUT_ENTITY: {
                this.onList(entityResponse.getResults());
                break;
            }
            case PUT: {
                this.onUpdate((SocializeObject)entityResponse.getFirstResult());
                break;
            }
            case PUT_AS_POST: {
                this.onUpdate((SocializeObject)entityResponse.getFirstResult());
                break;
            }
            case POST: {
                this.onCreate((SocializeObject)entityResponse.getFirstResult());
                break;
            }
            case DELETE: {
                this.onDelete();
            }
        }
    }

    public abstract void onGet(T var1);

    public abstract void onList(ListResult<T> var1);

    public abstract void onUpdate(T var1);

    public abstract void onCreate(T var1);

    public abstract void onDelete();

    public void onCancel() {
    }

    @Override
    public abstract void onError(SocializeException var1);

    protected final boolean isNotFoundError(SocializeException error) {
        if (error instanceof SocializeApiError) {
            return ((SocializeApiError)error).getResultCode() == 404;
        }
        return false;
    }
}

