/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher.task;

import android.content.Context;
import android.os.Bundle;
import com.socialize.error.SocializeException;
import com.socialize.launcher.LaunchTask;
import com.socialize.log.SocializeLogger;
import java.util.List;

public class NotificationLaunchTask
implements LaunchTask {
    private List<LaunchTask> tasks;
    private SocializeLogger logger;

    @Override
    public void execute(Context context, Bundle extras) throws SocializeException {
        if (this.tasks != null) {
            for (LaunchTask task : this.tasks) {
                try {
                    task.execute(context, extras);
                }
                catch (SocializeException e) {
                    if (this.logger != null) {
                        this.logger.error("Error executing launcher task", (Throwable)e);
                        continue;
                    }
                    SocializeLogger.e(e.getMessage(), e);
                }
            }
        }
    }

    public void setTasks(List<LaunchTask> tasks) {
        this.tasks = tasks;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

