/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebView;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.launcher.BaseLauncher;
import com.socialize.launcher.UrlLauncher;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.FullScreenDialogFactory;
import com.socialize.ui.notifications.DirectUrlListener;
import com.socialize.ui.notifications.DirectUrlWebView;
import com.socialize.util.DefaultAppUtils;
import com.socialize.util.StringUtils;

public class SocializeUrlLauncher
extends BaseLauncher
implements UrlLauncher {
    private SocializeLogger logger;
    private FullScreenDialogFactory dialogFactory;
    private IBeanFactory<DirectUrlWebView> directUrlWebViewFactory;
    private DirectUrlListener directUrlListener;

    @Override
    public boolean launch(final Activity context, Bundle data) {
        String url = data.getString("socialize.direct.url");
        if (!StringUtils.isEmpty(url)) {
            final DirectUrlWebView webView = (DirectUrlWebView)((Object)this.directUrlWebViewFactory.getBean());
            webView.setListener(this.directUrlListener);
            Dialog dialog = this.dialogFactory.build(context, (View)webView, true);
            dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    SocializeUrlLauncher.this.handleCloseEvent(webView, context);
                }
            });
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    SocializeUrlLauncher.this.handleCloseEvent(webView, context);
                }
            });
            dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4 && webView.canGoBack()) {
                        webView.goBack();
                        return true;
                    }
                    return false;
                }
            });
            boolean show = true;
            if (this.directUrlListener != null) {
                show = this.directUrlListener.onBeforePageLoaded(webView, url);
            }
            if (show) {
                dialog.show();
                webView.loadUrl(url);
            }
            return show;
        }
        this.handleWarn("No url found under key [socialize.direct.url]");
        return false;
    }

    protected void handleCloseEvent(WebView webView, Activity context) {
        if (this.directUrlListener != null) {
            this.directUrlListener.onDialogClose();
        }
        if (webView != null) {
            try {
                webView.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DefaultAppUtils.launchMainApp(context);
        context.finish();
    }

    protected void handleWarn(String msg) {
        if (this.logger != null) {
            this.logger.warn(msg);
        } else {
            System.err.println(msg);
        }
    }

    @Override
    public boolean shouldFinish(Activity context) {
        return false;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setDialogFactory(FullScreenDialogFactory dialogFactory) {
        this.dialogFactory = dialogFactory;
    }

    public void setDirectUrlWebViewFactory(IBeanFactory<DirectUrlWebView> directUrlWebViewFactory) {
        this.directUrlWebViewFactory = directUrlWebViewFactory;
    }

    @Override
    public void setDirectUrlListener(DirectUrlListener directUrlListener) {
        this.directUrlListener = directUrlListener;
    }
}

