/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.init;

import android.content.Context;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.error.SocializeException;
import com.socialize.init.SocializeInitializationAsserter;
import com.socialize.listener.SocializeListener;
import com.socialize.log.SocializeLogger;

public class DefaultInitializationAsserter
implements SocializeInitializationAsserter {
    private SocializeLogger logger;

    @Override
    public boolean assertAuthenticated(SocializeService service, SocializeSession session, SocializeListener listener) {
        if (session != null) {
            return true;
        }
        if (listener != null) {
            if (this.logger != null) {
                listener.onError(new SocializeException(this.logger.getMessage(2)));
            } else {
                listener.onError(new SocializeException("Not authenticated"));
            }
        }
        if (this.logger != null) {
            this.logger.error(2);
        }
        return false;
    }

    @Override
    public boolean assertInitialized(Context context, SocializeService service, SocializeListener listener) {
        boolean initialized = service.isInitialized(context);
        if (!initialized) {
            if (listener != null) {
                if (this.logger != null) {
                    listener.onError(new SocializeException(this.logger.getMessage(1)));
                } else {
                    listener.onError(new SocializeException("Not initialized"));
                }
            }
            if (this.logger != null) {
                this.logger.error(1);
            }
        }
        return initialized;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

