/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.Stats;
import com.socialize.entity.StatsFactory;
import com.socialize.entity.User;
import com.socialize.entity.UserAuthData;
import com.socialize.entity.UserAuthDataFactory;
import com.socialize.util.StringUtils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserFactory
extends SocializeObjectFactory<User> {
    private StatsFactory statsFactory;
    private UserAuthDataFactory userAuthDataFactory;
    public static final String META = "meta";
    public static final String FIRST_NAME = "first_name";
    public static final String LAST_NAME = "last_name";
    public static final String USERNAME = "username";
    public static final String DESCRIPTION = "description";
    public static final String LOCATION = "location";
    public static final String IMAGE_DATA = "picture";
    public static final String SMALL_IMAGE_URI = "small_image_uri";
    public static final String MEDIUM_IMAGE_URI = "medium_image_uri";
    public static final String LARGE_IMAGE_URI = "large_image_uri";
    public static final String STATS = "stats";
    public static final String THIRD_PARTY_AUTH = "third_party_auth";
    public static final String AUTO_POST_FACEBOOK = "auto_post_fb";
    public static final String AUTO_POST_TWITTER = "auto_post_tw";
    public static final String AUTO_POST_LIKES_FACEBOOK = "auto_post_likes_fb";
    public static final String AUTO_POST_COMMENTS_FACEBOOK = "auto_post_comments_fb";
    public static final String NOTIFICATIONS_ENABLED = "notifications_enabled";
    public static final String SHARE_LOCATION = "share_location";

    @Override
    public Object instantiateObject(JSONObject object) {
        return new User();
    }

    @Override
    protected void postFromJSON(JSONObject object, User user) throws JSONException {
        JSONArray authJson;
        JSONObject statsJson;
        user.setMetaData(this.getString(object, META));
        user.setFirstName(this.getString(object, FIRST_NAME));
        user.setLastName(this.getString(object, LAST_NAME));
        user.setUsername(this.getString(object, USERNAME));
        user.setDescription(this.getString(object, DESCRIPTION));
        user.setLocation(this.getString(object, LOCATION));
        user.setSmallImageUri(this.getString(object, SMALL_IMAGE_URI));
        user.setMediumImageUri(this.getString(object, MEDIUM_IMAGE_URI));
        user.setLargeImageUri(this.getString(object, LARGE_IMAGE_URI));
        user.setProfilePicData(this.getString(object, IMAGE_DATA));
        if (object.has(STATS) && !object.isNull(STATS) && (statsJson = object.getJSONObject(STATS)) != null && this.statsFactory != null) {
            Stats stats = (Stats)this.statsFactory.fromJSON(statsJson);
            user.setStats(stats);
        }
        if (object.has(THIRD_PARTY_AUTH) && !object.isNull(THIRD_PARTY_AUTH) && (authJson = object.getJSONArray(THIRD_PARTY_AUTH)) != null && authJson.length() > 0 && this.userAuthDataFactory != null) {
            int length = authJson.length();
            for (int i = 0; i < length; ++i) {
                UserAuthData authData = (UserAuthData)this.userAuthDataFactory.fromJSON(authJson.getJSONObject(i));
                user.addUserAuthData(authData);
            }
        }
    }

    @Override
    protected void postToJSON(User user, JSONObject object) throws JSONException {
        String metaData = user.getMetaData();
        if (!StringUtils.isEmpty(metaData)) {
            object.put(META, (Object)metaData);
        } else {
            object.put(META, (Object)"");
        }
        object.put(FIRST_NAME, (Object)user.getFirstName());
        object.put(LAST_NAME, (Object)user.getLastName());
        object.put(DESCRIPTION, (Object)user.getDescription());
        object.put(LOCATION, (Object)user.getLocation());
        object.put(IMAGE_DATA, (Object)user.getProfilePicData());
        object.put(SMALL_IMAGE_URI, (Object)user.getSmallImageUri());
        object.put(MEDIUM_IMAGE_URI, (Object)user.getMediumImageUri());
        object.put(LARGE_IMAGE_URI, (Object)user.getLargeImageUri());
        List<UserAuthData> authData = user.getAuthData();
        if (authData != null && authData.size() > 0) {
            object.put(THIRD_PARTY_AUTH, (Object)this.userAuthDataFactory.toJSON(authData));
        }
    }

    public StatsFactory getStatsFactory() {
        return this.statsFactory;
    }

    public UserAuthDataFactory getUserAuthDataFactory() {
        return this.userAuthDataFactory;
    }

    public void setStatsFactory(StatsFactory statsFactory) {
        this.statsFactory = statsFactory;
    }

    public void setUserAuthDataFactory(UserAuthDataFactory userAuthDataFactory) {
        this.userAuthDataFactory = userAuthDataFactory;
    }
}

