/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.SocializeObject;
import com.socialize.entity.Stats;
import com.socialize.entity.UserAuthData;
import com.socialize.networks.SocialNetwork;
import com.socialize.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class User
extends SocializeObject {
    private static final long serialVersionUID = 235116049047552159L;
    private String firstName;
    private String lastName;
    private String username;
    private String description;
    private String location;
    private String smallImageUri;
    private String mediumImageUri;
    private String largeImageUri;
    private Stats stats;
    private List<UserAuthData> authData;
    private String displayName;
    private String profilePicData;
    @Deprecated
    private boolean autoPostToFacebook = false;
    @Deprecated
    private boolean autoPostToTwitter = false;
    @Deprecated
    private boolean shareLocation = true;
    @Deprecated
    private boolean notificationsEnabled = true;
    private String metaData;

    public void update(User user) {
        this.setFirstName(user.getFirstName());
        this.setLastName(user.getLastName());
        this.setUsername(user.getUsername());
        this.setLocation(user.getLocation());
        this.setSmallImageUri(user.getSmallImageUri());
        this.setMediumImageUri(user.getMediumImageUri());
        this.setLargeImageUri(user.getLargeImageUri());
        this.setStats(user.getStats());
        this.setAuthData(user.getAuthData());
        this.setProfilePicData(user.getProfilePicData());
        this.setMetaData(user.getMetaData());
        this.displayName = null;
    }

    public String getShortDisplayName() {
        String fname = this.getFirstName();
        if (!StringUtils.isEmpty(fname)) {
            return fname;
        }
        return this.getUsername();
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            String fname = this.getFirstName();
            String sname = this.getLastName();
            String uname = this.getUsername();
            if (!StringUtils.isEmpty(fname)) {
                this.displayName = fname;
                if (!StringUtils.isEmpty(sname)) {
                    this.displayName = this.displayName + " " + sname;
                }
            } else if (!StringUtils.isEmpty(sname)) {
                this.displayName = sname;
            } else if (!StringUtils.isEmpty(uname)) {
                this.displayName = uname;
            }
        }
        return this.displayName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSmallImageUri() {
        return this.smallImageUri;
    }

    public void setSmallImageUri(String smallImageUri) {
        this.smallImageUri = smallImageUri;
    }

    public String getMediumImageUri() {
        return this.mediumImageUri;
    }

    public void setMediumImageUri(String mediumImageUri) {
        this.mediumImageUri = mediumImageUri;
    }

    public String getLargeImageUri() {
        return this.largeImageUri;
    }

    public void setLargeImageUri(String largeImageUri) {
        this.largeImageUri = largeImageUri;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public String getProfilePicData() {
        return this.profilePicData;
    }

    public void setProfilePicData(String profilePicData) {
        this.profilePicData = profilePicData;
    }

    @Deprecated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<UserAuthData> getAuthData() {
        return this.authData;
    }

    public synchronized void addUserAuthData(UserAuthData authData) {
        if (this.authData == null) {
            this.authData = new ArrayList<UserAuthData>(5);
        }
        this.authData.add(authData);
    }

    public void setAuthData(List<UserAuthData> authData) {
        this.authData = authData;
    }

    @Deprecated
    public boolean isAutoPostToFacebook() {
        return this.autoPostToFacebook;
    }

    @Deprecated
    public void setAutoPostToFacebook(boolean autoPostToFacebook) {
        this.autoPostToFacebook = autoPostToFacebook;
    }

    @Deprecated
    public boolean isAutoPostToTwitter() {
        return this.autoPostToTwitter;
    }

    @Deprecated
    public void setAutoPostToTwitter(boolean autoPostToTwitter) {
        this.autoPostToTwitter = autoPostToTwitter;
    }

    @Deprecated
    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    @Deprecated
    public void setNotificationsEnabled(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    @Deprecated
    public boolean isShareLocation() {
        return this.shareLocation;
    }

    @Deprecated
    public void setShareLocation(boolean shareLocation) {
        this.shareLocation = shareLocation;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Deprecated
    public boolean setAutoPostPreferences(SocialNetwork ... networks) {
        boolean tw = this.isAutoPostToTwitter();
        boolean fb = this.isAutoPostToFacebook();
        this.setAutoPostToFacebook(false);
        this.setAutoPostToTwitter(false);
        if (networks != null) {
            for (SocialNetwork network : networks) {
                if (network.equals((Object)SocialNetwork.FACEBOOK)) {
                    this.setAutoPostToFacebook(true);
                    continue;
                }
                if (!network.equals((Object)SocialNetwork.TWITTER)) continue;
                this.setAutoPostToTwitter(true);
            }
        }
        return tw != this.isAutoPostToTwitter() || fb != this.isAutoPostToFacebook();
    }
}

