/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.Application;
import com.socialize.entity.ApplicationFactory;
import com.socialize.entity.Entity;
import com.socialize.entity.EntityFactory;
import com.socialize.entity.Propagation;
import com.socialize.entity.PropagationFactory;
import com.socialize.entity.PropagationInfoResponse;
import com.socialize.entity.PropagationInfoResponseFactory;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.User;
import com.socialize.entity.UserFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.util.StringUtils;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SocializeActionFactory<T extends SocializeAction>
extends SocializeObjectFactory<T> {
    protected SocializeLogger logger;
    private ApplicationFactory applicationFactory;
    private UserFactory userFactory;
    private EntityFactory entityFactory;
    private PropagationFactory propagationFactory;
    private PropagationInfoResponseFactory propagationInfoResponseFactory;

    @Override
    protected void toJSON(T from, JSONObject to) throws JSONException {
        super.toJSON(from, to);
        try {
            Entity entityObject = ((SocializeAction)from).getEntity();
            String entityKey = ((SocializeAction)from).getEntityKey();
            Application appObject = ((SocializeAction)from).getApplication();
            Propagation propagation = ((SocializeAction)from).getPropagation();
            Propagation propagationInfoRequest = ((SocializeAction)from).getPropagationInfoRequest();
            User userObject = ((SocializeAction)from).getUser();
            Double lat = ((SocializeAction)from).getLat();
            Double lon = ((SocializeAction)from).getLon();
            Long date = ((SocializeAction)from).getDate();
            if (entityObject != null && this.entityFactory != null) {
                if (!StringUtils.isEmpty(entityObject.getName()) && !StringUtils.isEmpty(entityObject.getKey())) {
                    JSONObject entity = this.entityFactory.toJSON(entityObject);
                    to.put("entity", (Object)entity);
                } else if (!StringUtils.isEmpty(entityKey)) {
                    to.put("entity_key", (Object)entityKey);
                }
            } else if (!StringUtils.isEmpty(entityKey)) {
                to.put("entity_key", (Object)entityKey);
            }
            if (appObject != null && this.applicationFactory != null) {
                JSONObject application = this.applicationFactory.toJSON(appObject);
                to.put("application", (Object)application);
            }
            if (this.propagationFactory != null) {
                if (propagation != null) {
                    to.put("propagation", (Object)this.propagationFactory.toJSON(propagation));
                }
                if (propagationInfoRequest != null) {
                    to.put("propagation_info_request", (Object)this.propagationFactory.toJSON(propagationInfoRequest));
                }
            }
            if (userObject != null) {
                JSONObject user = this.userFactory.toJSON(userObject);
                to.put("user", (Object)user);
            }
            if (lat != null) {
                to.put("lat", (Object)lat);
            }
            if (lon != null) {
                to.put("lng", (Object)lon);
            }
            if (date != null) {
                to.put("date", (Object)this.DATE_FORMAT.format(date));
            }
            to.put("share_location", ((SocializeAction)from).isLocationShared());
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage());
        }
    }

    protected JSONArray newJSONArray() {
        return new JSONArray();
    }

    @Override
    protected void fromJSON(JSONObject from, T to) throws JSONException {
        super.fromJSON(from, to);
        try {
            JSONObject application = this.getJSONObject(from, "application");
            JSONObject user = this.getJSONObject(from, "user");
            JSONObject entity = this.getJSONObject(from, "entity");
            JSONObject propagationInfoResponse = this.getJSONObject(from, "propagation_info_response");
            if (application != null) {
                ((SocializeAction)to).setApplication((Application)this.applicationFactory.fromJSON(application));
            }
            if (user != null) {
                ((SocializeAction)to).setUser((User)this.userFactory.fromJSON(user));
            }
            if (entity != null) {
                ((SocializeAction)to).setEntity((Entity)this.entityFactory.fromJSON(entity));
            }
            if (propagationInfoResponse != null) {
                ((SocializeAction)to).setPropagationInfoResponse((PropagationInfoResponse)this.propagationInfoResponseFactory.fromJSON(propagationInfoResponse));
            }
            ((SocializeAction)to).setEntityKey(this.getString(from, "entity_key"));
            ((SocializeAction)to).setLat(this.getDouble(from, "lat"));
            ((SocializeAction)to).setLon(this.getDouble(from, "lng"));
            ((SocializeAction)to).setLocationShared(this.getBoolean(from, "share_location", false));
            if (this.exists(from, "date")) {
                try {
                    ((SocializeAction)to).setDate(this.DATE_FORMAT.parse(from.getString("date")).getTime());
                }
                catch (ParseException e) {
                    if (this.logger != null && this.logger.isWarnEnabled()) {
                        this.logger.warn("Could not parse date [" + from.getString("date") + "] using format [" + "yyyy-MM-dd HH:mm:ssZZ" + "]");
                    }
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof NullPointerException) {
                throw new JSONException("NullPointerException at fromJSON");
            }
            throw new JSONException(e.getMessage());
        }
    }

    public SocializeLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setApplicationFactory(ApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
    }

    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setPropagationFactory(PropagationFactory propagationFactory) {
        this.propagationFactory = propagationFactory;
    }

    public void setPropagationInfoResponseFactory(PropagationInfoResponseFactory propagationInfoResponseFactory) {
        this.propagationInfoResponseFactory = propagationInfoResponseFactory;
    }

    @Override
    protected abstract void postToJSON(T var1, JSONObject var2) throws JSONException;

    @Override
    protected abstract void postFromJSON(JSONObject var1, T var2) throws JSONException;
}

