/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.api.action.ActionType;
import com.socialize.entity.Application;
import com.socialize.entity.Entity;
import com.socialize.entity.Propagation;
import com.socialize.entity.PropagationInfoResponse;
import com.socialize.entity.SocializeObject;
import com.socialize.entity.User;
import com.socialize.util.StringUtils;

public abstract class SocializeAction
extends SocializeObject {
    private static final long serialVersionUID = -1988365314114134147L;
    private Application application;
    private Propagation propagation;
    private Propagation propagationInfoRequest;
    private PropagationInfoResponse propagationInfoResponse;
    private Entity entity;
    private String entityKey;
    private User user;
    private Double lon;
    private Double lat;
    private Long date;
    private boolean locationShared;
    private boolean notificationsEnabled;

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setEntitySafe(Entity entity) {
        if (StringUtils.isEmpty(entity.getName())) {
            this.setEntityKey(entity.getKey());
        } else {
            this.setEntity(entity);
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getEntityDisplayName() {
        if (this.entity != null) {
            return this.entity.getDisplayName();
        }
        return this.entityKey;
    }

    public String getEntityKey() {
        if (StringUtils.isEmpty(this.entityKey) && this.entity != null) {
            return this.entity.getKey();
        }
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public boolean hasLocation() {
        return this.lon != null && this.lat != null;
    }

    public boolean isLocationShared() {
        return this.locationShared;
    }

    public void setLocationShared(boolean locationShared) {
        this.locationShared = locationShared;
    }

    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void setNotificationsEnabled(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public Propagation getPropagationInfoRequest() {
        return this.propagationInfoRequest;
    }

    public void setPropagationInfoRequest(Propagation propagationRequest) {
        this.propagationInfoRequest = propagationRequest;
    }

    public PropagationInfoResponse getPropagationInfoResponse() {
        return this.propagationInfoResponse;
    }

    public void setPropagationInfoResponse(PropagationInfoResponse propagationInfoResponse) {
        this.propagationInfoResponse = propagationInfoResponse;
    }

    public abstract ActionType getActionType();

    public String getDisplayText() {
        if (this.entity != null) {
            String name = this.entity.getName();
            String key = this.entity.getKey();
            if (!StringUtils.isEmpty(name)) {
                return name;
            }
            return key;
        }
        return this.entityKey;
    }
}

