/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JSONFactory<T> {
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ssZZ";
    protected final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZZ");

    public JSONArray toJSON(Collection<T> objects) throws JSONException {
        JSONArray array = this.instantiateJSONArray();
        for (T t : objects) {
            array.put((Object)this.toJSON(t));
        }
        return array;
    }

    public JSONObject toJSON(T object) throws JSONException {
        JSONObject json = this.instantiateJSON();
        this.toJSON(object, json);
        return json;
    }

    public T fromJSON(JSONObject json) throws JSONException {
        Object object = this.instantiateObject(json);
        if (object != null) {
            this.fromJSON(json, object);
        }
        return (T)object;
    }

    public JSONObject instantiateJSON() {
        return new JSONObject();
    }

    public JSONArray instantiateJSONArray() {
        return new JSONArray();
    }

    protected boolean exists(JSONObject obj, String key) throws JSONException {
        return obj.has(key) && !obj.isNull(key);
    }

    protected String getString(JSONObject obj, String key) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getString(key);
        }
        return null;
    }

    protected Double getDouble(JSONObject obj, String key) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getDouble(key);
        }
        return null;
    }

    protected boolean getBoolean(JSONObject obj, String key, boolean defaultValue) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getBoolean(key);
        }
        return defaultValue;
    }

    protected JSONObject getJSONObject(JSONObject obj, String key) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getJSONObject(key);
        }
        return null;
    }

    protected int getInt(JSONObject obj, String key) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getInt(key);
        }
        return 0;
    }

    protected long getLong(JSONObject obj, String key) throws JSONException {
        return this.getLong(obj, key, 0L);
    }

    protected long getLong(JSONObject obj, String key, long defaultValue) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getLong(key);
        }
        return defaultValue;
    }

    protected Long getLongObject(JSONObject obj, String key) throws JSONException {
        if (this.exists(obj, key)) {
            return obj.getLong(key);
        }
        return null;
    }

    public abstract Object instantiateObject(JSONObject var1);

    protected abstract void fromJSON(JSONObject var1, T var2) throws JSONException;

    protected abstract void toJSON(T var1, JSONObject var2) throws JSONException;
}

