/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.os.AsyncTask;
import com.socialize.auth.twitter.OAuthRequestTokenUrlListener;
import com.socialize.oauth.signpost.OAuthConsumer;
import com.socialize.oauth.signpost.OAuthTokenListener;
import com.socialize.oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import com.socialize.oauth.signpost.http.HttpParameters;
import org.apache.http.client.HttpClient;

public class TwitterOAuthProvider
extends CommonsHttpOAuthProvider {
    private static final long serialVersionUID = 3804709921717607933L;
    public static final String OAUTH_CALLBACK_URL = "socializeoauth://sign-in-with-twitter";
    public static final String REQUEST_TOKEN_ENDPOINT = "https://api.twitter.com/oauth/request_token";
    public static final String ACCESS_TOKEN_ENDPOINT = "https://api.twitter.com/oauth/access_token";
    public static final String AUTHORIZE_ENDPOINT = "https://api.twitter.com/oauth/authorize";

    public TwitterOAuthProvider(HttpClient httpClient) {
        super(REQUEST_TOKEN_ENDPOINT, ACCESS_TOKEN_ENDPOINT, AUTHORIZE_ENDPOINT, httpClient);
    }

    public TwitterOAuthProvider() {
        super(REQUEST_TOKEN_ENDPOINT, ACCESS_TOKEN_ENDPOINT, AUTHORIZE_ENDPOINT);
    }

    public void retrieveRequestTokenAsync(final OAuthConsumer consumer, final String callbackUrl, final OAuthRequestTokenUrlListener listener) {
        new AsyncTask<Void, Void, Void>(){
            String url;
            Exception error;

            protected Void doInBackground(Void ... params) {
                try {
                    this.url = TwitterOAuthProvider.this.retrieveRequestToken(consumer, callbackUrl);
                }
                catch (Exception e) {
                    this.error = e;
                }
                return null;
            }

            protected void onPostExecute(Void result) {
                if (listener != null) {
                    if (this.error != null) {
                        listener.onError(this.error);
                    } else {
                        listener.onRequestUrl(this.url);
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public void retrieveAccessTokenAsync(final OAuthConsumer consumer, final String oauthVerifier, final OAuthTokenListener listener) {
        new AsyncTask<Void, Void, Void>(){
            HttpParameters httpParameters = new HttpParameters();
            Exception error;

            protected Void doInBackground(Void ... params) {
                try {
                    TwitterOAuthProvider.this.retrieveAccessToken(consumer, oauthVerifier, new OAuthTokenListener(){

                        @Override
                        public void onResponse(HttpParameters parameters) {
                            httpParameters.merge(parameters);
                        }

                        @Override
                        public void onError(Exception e) {
                            error = e;
                        }
                    });
                }
                catch (Exception e) {
                    this.error = e;
                }
                return null;
            }

            protected void onPostExecute(Void result) {
                if (listener != null) {
                    if (this.error != null) {
                        listener.onError(this.error);
                    } else {
                        listener.onResponse(this.httpParameters);
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }
}

