/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.content.Context;
import com.socialize.auth.AuthProvider;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderResponse;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.twitter.TwitterAuthListener;
import com.socialize.auth.twitter.TwitterAuthProviderInfo;
import com.socialize.auth.twitter.TwitterAuthUtils;
import com.socialize.error.SocializeException;
import com.socialize.listener.AuthProviderListener;

public class TwitterAuthProvider
implements AuthProvider<TwitterAuthProviderInfo> {
    private TwitterAuthUtils twitterAuthUtils;
    private AuthProviderInfoBuilder authProviderInfoBuilder;

    @Override
    public void authenticate(Context context, TwitterAuthProviderInfo info, AuthProviderListener listener) {
        this.twitterAuthUtils.showAuthDialog(context, info, this.newTwitterAuthListener(listener));
    }

    @Override
    public boolean validateForRead(TwitterAuthProviderInfo info, String ... permissions) {
        if (this.authProviderInfoBuilder != null) {
            Object expected = this.authProviderInfoBuilder.getFactory(AuthProviderType.TWITTER).getInstanceForRead(new String[0]);
            return info.matches((AuthProviderInfo)expected);
        }
        return true;
    }

    @Override
    public boolean validateForWrite(TwitterAuthProviderInfo info, String ... permissions) {
        return this.validateForRead(info, permissions);
    }

    @Override
    @Deprecated
    public boolean validate(TwitterAuthProviderInfo info) {
        return this.validateForWrite(info, new String[0]);
    }

    protected TwitterAuthListener newTwitterAuthListener(final AuthProviderListener listener) {
        return new TwitterAuthListener(){

            @Override
            public void onError(SocializeException e) {
                if (listener != null) {
                    listener.onError(SocializeException.wrap(e));
                }
            }

            @Override
            public void onCancel() {
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onAuthSuccess(String token, String secret, String screenName, String userId) {
                if (listener != null) {
                    AuthProviderResponse response = TwitterAuthProvider.this.newAuthProviderResponse();
                    response.setToken(token);
                    response.setSecret(secret);
                    response.setUserId(userId);
                    listener.onAuthSuccess(response);
                }
            }
        };
    }

    protected AuthProviderResponse newAuthProviderResponse() {
        return new AuthProviderResponse();
    }

    @Override
    public void clearCache(Context context, TwitterAuthProviderInfo info) {
    }

    public void setTwitterAuthUtils(TwitterAuthUtils twitterUtils) {
        this.twitterAuthUtils = twitterUtils;
    }

    public void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }
}

