/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth;

import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderInfoFactory;
import com.socialize.auth.AuthProviderType;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import java.util.Collection;
import java.util.Map;

public class DefaultAuthProviderInfoBuilder
implements AuthProviderInfoBuilder {
    private Map<String, AuthProviderInfoFactory<?>> factories;
    private SocializeLogger logger;

    public void setFactories(Map<String, AuthProviderInfoFactory<?>> factories) {
        this.factories = factories;
    }

    @Override
    public <I extends AuthProviderInfo> AuthProviderInfoFactory<I> getFactory(AuthProviderType type) {
        return this.factories.get(type.name());
    }

    @Override
    public boolean validateAll() {
        boolean valid = true;
        Collection<AuthProviderInfoFactory<?>> values = this.factories.values();
        for (AuthProviderInfoFactory<?> factory : values) {
            Object instance = factory.getInstanceForRead(new String[0]);
            try {
                instance.validate();
            }
            catch (SocializeException e) {
                if (this.logger != null) {
                    this.logger.debug("Failed to validate auth provider [" + (Object)((Object)instance.getType()) + "] with error [" + e.getMessage() + "]");
                }
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public boolean isSupported(AuthProviderType type) {
        AuthProviderInfoFactory factory = this.getFactory(type);
        if (factory != null) {
            return factory.getInstanceForRead(new String[0]).isValid();
        }
        return false;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

