/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth;

import com.socialize.api.action.ShareType;
import com.socialize.networks.SocialNetwork;

public enum AuthProviderType {
    SOCIALIZE("socialize", 0),
    FACEBOOK("facebook", 1),
    TWITTER("twitter", 2);

    private final String name;
    private final int id;

    private AuthProviderType(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public static AuthProviderType valueOf(SocialNetwork socialNetwork) {
        if (socialNetwork == null) {
            return SOCIALIZE;
        }
        return AuthProviderType.valueOf(socialNetwork.name().toUpperCase());
    }

    public static AuthProviderType valueOf(ShareType shareType) {
        if (shareType == null) {
            return SOCIALIZE;
        }
        switch (shareType) {
            case EMAIL: {
                return SOCIALIZE;
            }
            case SMS: {
                return SOCIALIZE;
            }
            case OTHER: {
                return SOCIALIZE;
            }
        }
        return AuthProviderType.valueOf(shareType.getName().toUpperCase());
    }

    public static AuthProviderType valueOf(int id) {
        AuthProviderType[] values;
        for (AuthProviderType authProviderType : values = AuthProviderType.values()) {
            if (authProviderType.id != id) continue;
            return authProviderType;
        }
        return SOCIALIZE;
    }
}

