/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.user;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.SocializeActionUtilsBase;
import com.socialize.api.action.user.UserSystem;
import com.socialize.api.action.user.UserUtilsProxy;
import com.socialize.auth.AuthProviderType;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.SocializeInitListener;
import com.socialize.listener.user.UserGetListener;
import com.socialize.listener.user.UserSaveListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.action.ActionDetailActivity;
import com.socialize.ui.action.OnActionDetailViewListener;
import com.socialize.ui.comment.CommentDetailActivity;
import com.socialize.ui.profile.ProfileActivity;
import com.socialize.ui.profile.UserSettings;

public class SocializeUserUtils
extends SocializeActionUtilsBase
implements UserUtilsProxy {
    private UserSystem userSystem;
    private SocializeLogger logger;
    private ListenerHolder listenerHolder;

    @Override
    public UserSettings getUserSettings(Context context) throws SocializeException {
        SocializeSession session = this.getSocialize().getSession();
        if (session != null) {
            return session.getUserSettings();
        }
        throw new SocializeException("No current session");
    }

    @Override
    public void showUserSettingsViewForResult(Activity context, Long userId, int requestCode) {
        Class<Object> userSettingsActivity = Socialize.getSocialize().getUserSettingsActivity();
        if (userSettingsActivity == null) {
            userSettingsActivity = ProfileActivity.class;
        }
        Intent i = this.newIntent(context, userSettingsActivity);
        i.putExtra("socialize.user.id", userId.toString());
        try {
            context.startActivityForResult(i, requestCode);
        }
        catch (ActivityNotFoundException e) {
            this.logger.error("Could not find activity " + userSettingsActivity + ".  Make sure you have added this to your AndroidManifest.xml");
        }
    }

    @Override
    public void showUserSettingsView(Activity context, Long userId) {
        Class<Object> userSettingsActivity = Socialize.getSocialize().getUserSettingsActivity();
        if (userSettingsActivity == null) {
            userSettingsActivity = ProfileActivity.class;
        }
        Intent i = this.newIntent(context, userSettingsActivity);
        i.putExtra("socialize.user.id", userId.toString());
        try {
            context.startActivity(i);
        }
        catch (ActivityNotFoundException e) {
            this.logger.error("Could not find activity " + userSettingsActivity + ".  Make sure you have added this to your AndroidManifest.xml");
        }
    }

    @Override
    public void showUserProfileView(Activity context, User user, SocializeAction action, OnActionDetailViewListener onActionDetailViewListener) {
        block7: {
            String listenerKey = "action_view";
            if (onActionDetailViewListener != null && this.listenerHolder != null) {
                this.listenerHolder.push("action_view", onActionDetailViewListener);
            }
            Intent i = this.newIntent(context, ActionDetailActivity.class);
            i.putExtra("socialize.user.id", user.getId().toString());
            if (action != null) {
                i.putExtra("socialize.action.id", action.getId().toString());
            }
            try {
                i.setFlags(0x20000000);
                context.startActivity(i);
            }
            catch (ActivityNotFoundException e) {
                i.setClass((Context)context, CommentDetailActivity.class);
                try {
                    context.startActivity(i);
                    if (this.logger != null) {
                        this.logger.warn("Using legacy CommentDetailActivity.  Please update your AndroidManifest.xml to use ActionDetailActivity");
                    }
                }
                catch (ActivityNotFoundException e2) {
                    if (this.logger == null) break block7;
                    this.logger.error("Could not find ActionDetailActivity.  Make sure you have added this to your AndroidManifest.xml");
                }
            }
        }
    }

    @Override
    public SocialNetwork[] getAutoPostSocialNetworks(Context context) throws SocializeException {
        SocializeService socialize = Socialize.getSocialize();
        UserSettings user = this.getUserSettings(context);
        SocialNetwork[] networks = null;
        if (user.isAutoPostFacebook() && socialize.isAuthenticatedForRead(AuthProviderType.FACEBOOK, new String[0])) {
            networks = user.isAutoPostTwitter() && socialize.isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0]) ? new SocialNetwork[]{SocialNetwork.FACEBOOK, SocialNetwork.TWITTER} : new SocialNetwork[]{SocialNetwork.FACEBOOK};
        } else if (user.isAutoPostTwitter() && socialize.isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0])) {
            networks = new SocialNetwork[]{SocialNetwork.TWITTER};
        }
        return networks;
    }

    @Override
    public User getCurrentUser(Context context) throws SocializeException {
        return this.getCurrentUser(context, false);
    }

    @Override
    public void getCurrentUserAsync(Context context, final UserGetListener listener) {
        User user;
        final SocializeService socialize = this.getSocialize();
        SocializeSession session = socialize.getSession();
        if (session != null && (user = session.getUser()) != null) {
            if (listener != null) {
                listener.onGet(user);
            }
            return;
        }
        if (!socialize.isInitialized(context)) {
            socialize.initAsync(context, new SocializeInitListener(){

                @Override
                public void onInit(Context context, IOCContainer container) {
                    SocializeUserUtils.this.getCurrentUserWithAuth(context, socialize, listener);
                }

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onError(error);
                    } else {
                        error.printStackTrace();
                    }
                }
            });
        } else {
            this.getCurrentUserWithAuth(context, socialize, listener);
        }
    }

    protected void getCurrentUserWithAuth(Context context, SocializeService socialize, final UserGetListener listener) {
        socialize.authenticate(context, new SocializeAuthListener(){

            @Override
            public void onAuthSuccess(SocializeSession session) {
                if (listener != null) {
                    listener.onGet(session.getUser());
                }
            }

            @Override
            public void onAuthFail(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                } else {
                    error.printStackTrace();
                }
            }

            @Override
            public void onCancel() {
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                } else {
                    error.printStackTrace();
                }
            }
        });
    }

    protected User getCurrentUser(Context context, boolean failOnError) throws SocializeException {
        User user;
        SocializeService socialize = this.getSocialize();
        SocializeSession session = socialize.getSession();
        if (session != null && (user = session.getUser()) != null) {
            return user;
        }
        if (failOnError) {
            if (this.logger != null) {
                this.logger.error("No user returned from getCurrentUser after second attempt");
            }
            throw new SocializeException("No user returned from getCurrentUser after second attempt");
        }
        if (!socialize.isInitialized(context)) {
            socialize.init(context);
        }
        if (!socialize.isAuthenticated()) {
            socialize.authenticateSynchronous(context);
        }
        return this.getCurrentUser(context, true);
    }

    @Override
    public void getUser(Context context, long id, UserGetListener listener) {
        this.userSystem.getUser(Socialize.getSocialize().getSession(), id, listener);
    }

    @Override
    public void saveUserAsync(Context context, User user, UserSaveListener listener) {
        this.userSystem.saveUserAsync(context, this.getSocialize().getSession(), user, listener);
    }

    @Override
    public void saveUserSettings(Context context, UserSettings userSettings, UserSaveListener listener) {
        this.userSystem.saveUserSettings(context, this.getSocialize().getSession(), userSettings, listener);
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    @Override
    public void clearSession(Context context) {
        this.getSocialize().clearSessionCache(context);
    }

    protected Intent newIntent(Activity context, Class<?> cls) {
        return new Intent((Context)context, cls);
    }

    public void setListenerHolder(ListenerHolder listenerHolder) {
        this.listenerHolder = listenerHolder;
    }
}

