/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.share;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.api.action.share.ShareSystem;
import com.socialize.auth.AuthProviderType;
import com.socialize.entity.Entity;
import com.socialize.entity.Share;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.share.ShareListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.provider.SocializeProvider;
import com.socialize.share.ShareHandler;
import com.socialize.share.ShareHandlers;
import java.util.ArrayList;

public class SocializeShareSystem
extends SocializeApi<Share, SocializeProvider<Share>>
implements ShareSystem {
    private ShareHandlers shareHandlers;
    private SocializeLogger logger;

    public SocializeShareSystem(SocializeProvider<Share> provider) {
        super(provider);
    }

    @Override
    public boolean canShare(Context context, ShareType shareType) {
        ShareHandler shareHandler = this.shareHandlers.getShareHandler(shareType);
        return shareHandler != null && shareHandler.isAvailableOnDevice(context);
    }

    @Override
    public void addShare(Context context, SocializeSession session, Entity entity, String text, SocialNetwork network, Location location, ShareListener listener) {
        this.addShare(context, session, entity, text, null, network, location, listener);
    }

    @Override
    public void addShare(Context context, SocializeSession session, Entity entity, String text, ShareType shareType, Location location, ShareListener listener) {
        this.addShare(context, session, entity, text, shareType, null, location, listener);
    }

    protected void addShare(Context context, final SocializeSession session, final Entity entity, final String text, ShareType shareType, SocialNetwork network, final Location location, final ShareListener listener) {
        if (shareType == null) {
            shareType = network != null ? ShareType.valueOf(network.name().toUpperCase()) : ShareType.OTHER;
        } else if (network == null) {
            network = SocialNetwork.valueOf(shareType);
        }
        final SocialNetwork fnetwork = network;
        final ShareType fshareType = shareType;
        if (network != null) {
            AuthProviderType authType = AuthProviderType.valueOf(network);
            if (this.getSocialize().isAuthenticatedForWrite(authType, new String[0])) {
                this.addShare(session, entity, text, shareType, location, listener, network);
            } else {
                this.getSocialize().authenticateForWrite(context, authType, new SocializeAuthListener(){

                    @Override
                    public void onError(SocializeException error) {
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }

                    @Override
                    public void onCancel() {
                        SocializeShareSystem.this.addShare(session, entity, text, fshareType, location, listener, new SocialNetwork[0]);
                    }

                    @Override
                    public void onAuthSuccess(SocializeSession session2) {
                        SocializeShareSystem.this.addShare(session2, entity, text, fshareType, location, listener, fnetwork);
                    }

                    @Override
                    public void onAuthFail(SocializeException error) {
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }
                }, new String[0]);
            }
        } else {
            this.addShare(session, entity, text, fshareType, location, listener, new SocialNetwork[0]);
        }
    }

    @Override
    public void addShare(Context context, SocializeSession session, Entity entity, String text, ShareType shareType, ShareListener listener, SocialNetwork ... network) {
        this.addShare(session, entity, text, shareType, null, listener, network);
    }

    @Override
    public void addShare(Context context, SocializeSession session, Entity entity, ShareType shareType, ShareListener listener, SocialNetwork ... network) {
        this.addShare(session, entity, "", shareType, null, listener, network);
    }

    public void addShare(SocializeSession session, Entity entity, String text, ShareType shareType, Location location, ShareListener listener, SocialNetwork ... network) {
        if (text == null) {
            text = "";
        }
        Share c = new Share();
        c.setEntitySafe(entity);
        c.setText(text);
        c.setShareType(shareType);
        if (network != null && network.length > 0) {
            ShareOptions shareOptions = new ShareOptions();
            shareOptions.setShowAuthDialog(true);
            this.setPropagationData(c, shareOptions, network);
        } else if (shareType != null) {
            this.setPropagationData(c, shareType);
        }
        this.setLocation(c);
        ArrayList<Share> list = new ArrayList<Share>(1);
        list.add(c);
        this.postAsync(session, "/share/", list, (SocializeActionListener)listener);
    }

    @Override
    public void getSharesByEntity(SocializeSession session, String key, int startIndex, int endIndex, ShareListener listener) {
        this.listAsync(session, "/share/", key, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getSharesByApplication(SocializeSession session, int startIndex, int endIndex, ShareListener listener) {
        this.listAsync(session, "/share/", null, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getSharesByUser(SocializeSession session, long userId, ShareListener listener) {
        String endpoint = "/user/" + userId + "/share/";
        this.listAsync(session, endpoint, listener);
    }

    @Override
    public void getSharesByUser(SocializeSession session, long userId, int startIndex, int endIndex, ShareListener listener) {
        String endpoint = "/user/" + userId + "/share/";
        this.listAsync(session, endpoint, startIndex, endIndex, listener);
    }

    @Override
    public void getShare(SocializeSession session, long id, ShareListener listener) {
        this.getAsync(session, "/share/", String.valueOf(id), listener);
    }

    @Override
    public void getSharesById(SocializeSession session, ShareListener listener, long ... ids) {
        if (ids != null) {
            String[] strIds = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                strIds[i] = String.valueOf(ids[i]);
            }
            this.listAsync(session, "/share/", null, 0, 100, listener, strIds);
        } else if (listener != null) {
            listener.onError(new SocializeException("No ids supplied"));
        }
    }

    @Override
    public void share(Activity context, SocializeSession session, SocializeAction action, String comment, Location location, ShareType destination, SocialNetworkListener listener) {
        ShareHandler sharer = this.getSharer(destination);
        if (sharer != null) {
            sharer.handle(context, action, location, comment, listener);
        } else {
            if (listener != null) {
                listener.onNetworkError(context, SocialNetwork.valueOf(destination), new SocializeException("Unable to share to [" + destination.getDisplayName() + "] No sharer defined for type"));
            }
            if (this.logger != null) {
                this.logger.warn("Unable to share to [" + destination.getDisplayName() + "].  No sharer defined for this type.");
            }
        }
    }

    protected ShareHandler getSharer(ShareType destination) {
        ShareHandler sharer = null;
        if (this.shareHandlers != null) {
            sharer = this.shareHandlers.getShareHandler(destination);
        }
        if (sharer == null && this.logger != null) {
            this.logger.warn("No sharer found for network type [" + destination.name() + "]");
        }
        return sharer;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    public void setShareHandlers(ShareHandlers shareHandlers) {
        this.shareHandlers = shareHandlers;
    }

    @Override
    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

