/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.SocializeServiceImpl;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.annotations.NoAuth;
import com.socialize.annotations.Synchronous;
import com.socialize.api.SocializeSession;
import com.socialize.error.AuthCanceledException;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.SocializeInitListener;
import com.socialize.listener.SocializeListener;
import com.socialize.log.SocializeLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.http.MethodNotSupportedException;

public class SocializeActionProxy
implements InvocationHandler {
    private String delegateBean;
    private boolean synchronous = false;

    public SocializeActionProxy(String delegateBean) {
        this.delegateBean = delegateBean;
    }

    public SocializeActionProxy(String delegateBean, boolean synchronous) {
        this(delegateBean);
        this.synchronous = synchronous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.synchronous || method.isAnnotationPresent(Synchronous.class) || !this.isVoidMethod(method)) {
                Context context = this.findContext(args);
                if (context != null) {
                    SocializeActionProxy socializeActionProxy = this;
                    synchronized (socializeActionProxy) {
                        SocializeService socialize = Socialize.getSocialize();
                        if (!socialize.isInitialized(context)) {
                            socialize.init(context);
                            if (!socialize.isAuthenticated() && !method.isAnnotationPresent(NoAuth.class)) {
                                socialize.authenticateSynchronous(context);
                            }
                        }
                    }
                }
                return method.invoke(this.getBean(), args);
            }
            Activity context = this.findActivity(args);
            if (context == null) {
                throw new MethodNotSupportedException("No activity found in method arguments for method [" + method.getName() + "]");
            }
            SocializeListener listener = this.findListener(args);
            this.invokeWithInit(context, listener, method, args);
            return null;
        }
        catch (Throwable e) {
            SocializeLogger.e(e.getMessage(), e);
            throw e;
        }
    }

    protected boolean isVoidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType == null || returnType.equals(Void.TYPE);
    }

    protected void invokeWithInit(final Activity context, final SocializeListener listener, final Method method, final Object[] args) throws Throwable {
        SocializeServiceImpl service = this.getSocialize();
        if (service.isInitialized((Context)context)) {
            service.setContext((Context)context);
            this.invoke(context, listener, method, args);
        } else {
            service.initAsync((Context)context, new SocializeInitListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onError(error);
                    }
                }

                @Override
                public void onInit(Context ctx, IOCContainer container) {
                    block2: {
                        try {
                            SocializeActionProxy.this.invoke(context, listener, method, args);
                        }
                        catch (Throwable e) {
                            if (listener == null) break block2;
                            listener.onError(SocializeException.wrap(e));
                        }
                    }
                }
            });
        }
    }

    protected void invoke(Activity context, SocializeListener listener, Method method, Object[] args) throws Throwable {
        SocializeServiceImpl service = this.getSocialize();
        if (!service.isAuthenticated() && !method.isAnnotationPresent(NoAuth.class)) {
            this.doAuthAsync(context, listener, method, args);
        } else {
            method.invoke(this.getBean(), args);
        }
    }

    protected Object getBean() throws MethodNotSupportedException {
        Object bean = Socialize.getBean(this.delegateBean);
        if (bean != null) {
            return bean;
        }
        throw new MethodNotSupportedException("No bean with name [" + this.delegateBean + "] found");
    }

    protected Activity findActivity(Object[] args) {
        for (Object object : args) {
            if (!(object instanceof Activity)) continue;
            return (Activity)object;
        }
        return null;
    }

    protected Context findContext(Object[] args) {
        for (Object object : args) {
            if (!(object instanceof Context)) continue;
            return (Context)object;
        }
        return null;
    }

    protected SocializeListener findListener(Object[] args) {
        for (Object object : args) {
            if (!(object instanceof SocializeListener)) continue;
            return (SocializeListener)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized <L extends SocializeListener> void doAuthAsync(final Activity context, final SocializeListener listener, final Method method, final Object[] args) throws Throwable {
        final SocializeServiceImpl service = this.getSocialize();
        if (!service.isAuthenticated()) {
            SocializeActionProxy socializeActionProxy = this;
            synchronized (socializeActionProxy) {
                if (!service.isAuthenticated()) {
                    context.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            service.authenticate((Context)context, new SocializeAuthListener(){

                                @Override
                                public void onError(SocializeException error) {
                                    if (listener != null) {
                                        listener.onError(error);
                                    }
                                }

                                @Override
                                public void onCancel() {
                                    if (listener != null) {
                                        listener.onError(new AuthCanceledException("Authentication was canceled by the user"));
                                    }
                                }

                                @Override
                                public void onAuthSuccess(SocializeSession session) {
                                    block2: {
                                        try {
                                            SocializeActionProxy.this.invoke(context, listener, method, args);
                                        }
                                        catch (Throwable e) {
                                            if (listener == null) break block2;
                                            listener.onError(SocializeException.wrap(e));
                                        }
                                    }
                                }

                                @Override
                                public void onAuthFail(SocializeException error) {
                                    if (listener != null) {
                                        listener.onError(error);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.invoke(context, listener, method, args);
                }
            }
        } else {
            this.invoke(context, listener, method, args);
        }
    }

    protected SocializeServiceImpl getSocialize() {
        return (SocializeServiceImpl)Socialize.getSocialize();
    }
}

