/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.socialize.Socialize;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.SocializeC2DMReceiverHandler;

public class SmartAlertUtils {
    static SocializeC2DMReceiverHandler handler = null;
    static final Object syncLock = new Object();

    public static boolean onMessage(Context context, Intent intent) {
        String source;
        SmartAlertUtils.assertInitialized(context);
        Bundle messageData = intent.getExtras();
        if (messageData != null && (source = messageData.getString("source")) != null && source.trim().equalsIgnoreCase("socialize")) {
            handler.onMessage(context, intent);
            return true;
        }
        return false;
    }

    public static void onRegister(Context context, String registrationId) {
        SmartAlertUtils.assertInitialized(context);
        handler.onRegistered(context, registrationId);
    }

    public static void onError(Context context, String errorId) {
        SmartAlertUtils.assertInitialized(context);
        handler.onError(context, errorId);
    }

    public static void onUnregister(Context context, String registrationId) {
        SmartAlertUtils.assertInitialized(context);
        handler.onUnregistered(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void assertInitialized(Context context) {
        if (handler == null) {
            Object object = syncLock;
            synchronized (object) {
                if (handler == null) {
                    handler = new SocializeC2DMReceiverHandler();
                    handler.onCreate(context);
                }
            }
        }
    }

    static void logNotInitializedError() {
        Log.e((String)SocializeLogger.LOG_TAG, (String)"GCMUtils was not initialized.  Make sure you are calling onCreate in your receiver");
    }

    public static boolean handleBroadcastIntent(Context context, Intent intent) {
        return Socialize.getSocialize().handleBroadcastIntent(context, intent);
    }
}

