/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import com.socialize.SocializeActionProxy;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.api.action.share.ShareUtilsProxy;
import com.socialize.api.action.share.SocialNetworkDialogListener;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.entity.Entity;
import com.socialize.entity.User;
import com.socialize.listener.share.ShareAddListener;
import com.socialize.listener.share.ShareGetListener;
import com.socialize.listener.share.ShareListListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.auth.AuthDialogListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ShareUtils {
    public static final int EMAIL = 1;
    public static final int SMS = 2;
    public static final int FACEBOOK = 4;
    public static final int TWITTER = 8;
    public static final int SHOW_REMEMBER = 16;
    public static final int MORE_OPTIONS = 32;
    public static final int GOOGLE_PLUS = 64;
    public static final int ALWAYS_CONTINUE = 128;
    public static final int SOCIAL = 76;
    public static final int DEFAULT = 111;
    public static final String EXTRA_TITLE = "title";
    public static final String EXTRA_TEXT = "text";
    public static final String EXTRA_SUBJECT = "subject";
    static ShareUtilsProxy proxy = (ShareUtilsProxy)Proxy.newProxyInstance(ShareUtilsProxy.class.getClassLoader(), new Class[]{ShareUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("shareUtils"));

    public static ShareOptions getUserShareOptions(Context context) {
        return proxy.getUserShareOptions(context);
    }

    public static void showLinkDialog(Activity context, AuthDialogListener listener) {
        proxy.showLinkDialog(context, listener);
    }

    public static void preloadShareDialog(Activity context) {
        proxy.preloadShareDialog(context);
    }

    public static void preloadLinkDialog(Activity context) {
        proxy.preloadLinkDialog(context);
    }

    public static void showShareDialog(Activity context, Entity entity) {
        proxy.showShareDialog(context, entity, 111, null, null);
    }

    public static void showShareDialog(Activity context, Entity entity, SocialNetworkDialogListener listener) {
        proxy.showShareDialog(context, entity, 111, listener, listener);
    }

    public static void showShareDialog(Activity context, Entity entity, SocialNetworkDialogListener listener, int options) {
        proxy.showShareDialog(context, entity, options, listener, listener);
    }

    public static void shareViaEmail(Activity context, Entity entity, ShareAddListener listener) {
        proxy.shareViaEmail(context, entity, listener);
    }

    public static void shareViaGooglePlus(Activity context, Entity entity, ShareAddListener listener) {
        proxy.shareViaGooglePlus(context, entity, listener);
    }

    public static void shareViaOther(Activity context, Entity entity, ShareAddListener listener) {
        proxy.shareViaOther(context, entity, listener);
    }

    public static void shareViaSMS(Activity context, Entity entity, ShareAddListener listener) {
        proxy.shareViaSMS(context, entity, listener);
    }

    public static void shareViaSocialNetworks(Activity context, Entity entity, ShareOptions shareOptions, SocialNetworkShareListener listener, SocialNetwork ... networks) {
        proxy.shareViaSocialNetworks(context, entity, shareOptions, listener, networks);
    }

    public static void getShare(Activity context, ShareGetListener listener, long id) {
        proxy.getShare(context, listener, id);
    }

    public static void getShares(Activity context, ShareListListener listener, long ... ids) {
        proxy.getShares(context, listener, ids);
    }

    public static void getSharesByUser(Activity context, User user, int start, int end, ShareListListener listener) {
        proxy.getSharesByUser(context, user, start, end, listener);
    }

    public static void getSharesByEntity(Activity context, String entityKey, int start, int end, ShareListListener listener) {
        proxy.getSharesByEntity(context, entityKey, start, end, listener);
    }

    public static void getSharesByApplication(Activity context, int start, int end, ShareListListener listener) {
        proxy.getSharesByApplication(context, start, end, listener);
    }

    public static void registerShare(Activity context, Entity entity, ShareOptions shareOptions, ShareAddListener listener, SocialNetwork ... networks) {
        proxy.registerShare(context, entity, shareOptions, listener, networks);
    }

    public static boolean canShareViaEmail(Activity context) {
        return proxy.canShareViaEmail(context);
    }

    public static boolean canShareViaSMS(Activity context) {
        return proxy.canShareViaSMS(context);
    }
}

