/*
 * Copyright (c) 2012 Socialize Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.socialize.i18n;


/**
 * @author Jason Polites
 *
 */
public class I18NConstants {

	private I18NConstants(){}
	
	public static final String COMMENT_SLIDER_TITLE = "socialize_comment_slider_title";
	public static final String COMMENT_BUTTON_ADD = "socialize_comment_button_add";
	public static final String COMMENT_SMARTALERTS_UNSUBSCRIBE = "socialize_comment_smartalerts_unsubscribe";
	public static final String COMMENT_SMARTALERTS_SUBSCRIBE = "socialize_comment_smartalerts_subscribe";
	public static final String COMMENT_SMARTALERTS_SUBSCRIBED_YES = "socialize_comment_smartalerts_subscribed_yes";
	public static final String COMMENT_SMARTALERTS_SUBSCRIBED_WILL_NOTIFY = "socialize_comment_smartalerts_subscribed_willnotify";
	public static final String COMMENT_SMARTALERTS_SUBSCRIBED_NO = "socialize_comment_smartalerts_subscribed_no";
	public static final String COMMENT_SMARTALERTS_SUBSCRIBE_ASK = "socialize_comment_smartalerts_subscribe_ask";
	public static final String COMMENT_HINT = "socialize_comment_hint";
	public static final String SHARE_MORE_OPTIONS = "socialize_share_more_options";
	public static final String SHARE_HEADER = "socialize_share_header";

	public static final String SHARE_TEXT_SHARING = "socialize_share_text_sharing";
	public static final String SHARE_TEXT_SHARED = "socialize_share_text_shared";
	public static final String SHARE_TEXT_SENT_FROM = "socialize_share_text_sent_from";

	public static final String SETTINGS_HEADER = "socialize_settings_header";
	public static final String SETTINGS_LABEL_FIRST_NAME = "socialize_settings_label_firstname";
	public static final String SETTINGS_LABEL_LAST_NAME = "socialize_settings_label_lastname";
	public static final String ACTIONBAR_COMMENT = "socialize_actionbar_label_comment";
	public static final String ACTIONBAR_SHARE = "socialize_actionbar_label_share";
	public static final String ACTIONBAR_LIKE = "socialize_actionbar_label_like";
	public static final String ACTIONBAR_UNLIKE = "socialize_actionbar_label_unlike";
	public static final String ACTIONBAR_SHARE_SUCCESS = "socialize_actionbar_toast_sharesuccess";
	public static final String ACTIONBAR_SHARE_FAIL = "socialize_actionbar_toast_sharefail";
	public static final String LOADING = "socialize_loading";
	public static final String PLEASE_WAIT = "socialize_please_wait";
	
	public static final String DLG_AUTH = "socialize_auth_dialog";
	public static final String DLG_AUTH_MESSAGE = "socialize_auth_dialog_message";
	public static final String DLG_SETTINGS = "socialize_settings_dialog";
	public static final String DLG_SHARE = "socialize_share_dialog";
	public static final String DLG_SHARE_MESSAGE = "socialize_share_dialog_message";
	public static final String DLG_COMMENT = "socialize_comment_dialog";
	public static final String DLG_AUTH_SIGNOUT = "socialize_auth_dialog_sign_out";
	
	public static final String AUTO_POST_FB = "socialize_facebook_autopost";
	public static final String AUTO_POST_TW = "socialize_twitter_autopost";
	
	public static final String DATE_DAY_SINGLE = "socialize_date_day";
	public static final String DATE_DAY_PLURAL = "socialize_date_day_plural";
	public static final String DATE_MONTH_SINGLE = "socialize_date_month";
	public static final String DATE_MONTH_PLURAL = "socialize_date_month_plural";
	public static final String DATE_AGO = "socialize_date_ago";
	public static final String DATE_JUST_NOW = "socialize_date_justnow";
	public static final String DATE_OVER_A_YEAR_AGO = "socialize_year_ago";
	public static final String DATE_HOUR_PLURAL = "socialize_date_hour_plural";
	public static final String DATE_HOUR_SINGLE = "socialize_date_hour";
	public static final String DATE_MINUTE_PLURAL = "socialize_date_minute_plural";
	public static final String DATE_MINUTE_SINGLE = "socialize_date_minute";
	
	public static final String AUTH_REQUIRED = "socialize_auth_required";
	public static final String AUTH_RATHER_NOT = "socialize_auth_rathernot";
	public static final String AUTH_ANONYMOUS = "socialize_auth_anonymous";
	public static final String AUTH_MESSAGE = "socialize_auth_message";
	public static final String AUTH_HEADER = "socialize_auth_header";
	
}
