/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.iOSAppInstallerInstaller;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;

public abstract class iOSAppInstallerBase
extends Builder {
    private final String url;
    private final String cloudTestServerID;
    private final String additionalOptions;

    protected iOSAppInstallerBase(String url, String cloudTestServerID, String additionalOptions) {
        this.url = url;
        this.cloudTestServerID = cloudTestServerID;
        this.additionalOptions = additionalOptions;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public CloudTestServer getServer() {
        return CloudTestServer.getByID(this.cloudTestServerID);
    }

    protected abstract void addArgs(EnvVars var1, ArgumentListBuilder var2);

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        CloudTestServer s = this.getServer();
        if (s == null) {
            throw new AbortException("No TouchTest server is configured in the system configuration.");
        }
        FilePath bin = new iOSAppInstallerInstaller(s).ios_app_installer(build.getBuiltOn(), (TaskListener)listener);
        args.add((Object)bin);
        this.addArgs(envs, args);
        args.add(new QuotedStringTokenizer(envs.expand(this.additionalOptions)).toArray());
        int exitCode = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
        return exitCode == 0;
    }
}

