/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins.httpclient;

import com.soasta.jenkins.ProxyChecker;
import com.soasta.jenkins.httpclient.HttpClientSettings;
import com.soasta.jenkins.httpclient.HttpException;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class GenericSelfClosingHttpClient {
    private static Logger m_log = Logger.getLogger(GenericSelfClosingHttpClient.class.getName());
    private CloseableHttpClient m_client;
    private boolean m_closeAfterUse = true;

    public GenericSelfClosingHttpClient(HttpClientSettings settings) {
        this.buildClient(settings);
    }

    public GenericSelfClosingHttpClient(HttpClientSettings settings, boolean closeAfterUse) {
        this.buildClient(settings);
        this.m_closeAfterUse = closeAfterUse;
    }

    public GenericSelfClosingHttpClient(CloseableHttpClient client) {
        this.m_client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendRequest(HttpUriRequest httpRequest) throws IOException {
        httpRequest.addHeader("User-Agent", "Jenkins/" + Jenkins.getVersion().toString());
        CloseableHttpResponse httpResponse = this.m_client.execute(httpRequest);
        try {
            String string;
            try {
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                String responseBody = httpResponse.getEntity() == null ? null : EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)this.getDefaultResponseCharacterSet());
                string = this.processResponse((HttpResponse)httpResponse, statusCode, responseBody);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            return string;
        }
        finally {
            if (this.m_closeAfterUse) {
                this.m_client.close();
            }
        }
    }

    private String getDefaultResponseCharacterSet() {
        return null;
    }

    private String processResponse(HttpResponse httpResponse, int statusCode, String responseBody) {
        if (statusCode < 300) {
            return responseBody;
        }
        throw new HttpException(statusCode, responseBody);
    }

    public void close() throws IOException {
        this.m_client.close();
    }

    private void buildClient(HttpClientSettings settings) {
        ProxyConfiguration proxyInfo;
        HttpClientBuilder builder = HttpClientBuilder.create();
        RegistryBuilder schemeRegistryBuilder = RegistryBuilder.create();
        schemeRegistryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        KeyManager[] keyManagers = GenericSelfClosingHttpClient.getKeyManagers(settings);
        TrustManager[] trustManagers = null;
        if (settings.trustSelfSigned()) {
            trustManagers = GenericSelfClosingHttpClient.getTrustAllSelfSigned();
        }
        try {
            SSLConnectionSocketFactory sslConnectionFactory = GenericSelfClosingHttpClient.getSSLFactory(keyManagers, trustManagers);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
            schemeRegistryBuilder.register("https", (Object)sslConnectionFactory);
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)schemeRegistryBuilder.build());
            builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        catch (Exception e) {
            m_log.log(Level.SEVERE, "Error Creating HTTP Client", e);
        }
        Jenkins jenkins = Jenkins.getInstance();
        ProxyConfiguration proxyConfiguration = proxyInfo = jenkins != null ? jenkins.proxy : null;
        if (proxyInfo != null) {
            HttpHost proxy = new HttpHost(proxyInfo.name, proxyInfo.port);
            String host = null;
            try {
                host = new URL(settings.getUrl()).getHost();
            }
            catch (MalformedURLException e) {
                m_log.log(Level.SEVERE, "Error Creating HTTP Client", e);
            }
            builder.setDefaultCredentialsProvider(this.getProxyCreds(proxyInfo, host));
            builder.setProxy(proxy);
        }
        this.m_client = builder.build();
    }

    public static KeyManager[] getKeyManagers(HttpClientSettings settings) {
        if (settings.getKeyStore() == null) {
            return null;
        }
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(settings.getKeyStore(), settings.getKeyStorePassword() == null || settings.getKeyStorePassword().isEmpty() ? null : settings.getKeyStorePassword().toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            m_log.log(Level.SEVERE, "Error Creating HTTP Client", e);
            return null;
        }
    }

    public static TrustManager[] getTrustAllSelfSigned() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    public static SSLConnectionSocketFactory getSSLFactory(KeyManager[] keyManager, TrustManager[] trustManagers) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManager, trustManagers, new SecureRandom());
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return sslConnectionFactory;
    }

    private CredentialsProvider getProxyCreds(ProxyConfiguration proxyInfo, String host) {
        BasicCredentialsProvider credentialsProvider = null;
        if (proxyInfo != null && proxyInfo.name != null && ProxyChecker.useProxy(host, proxyInfo)) {
            credentialsProvider = new BasicCredentialsProvider();
            if (proxyInfo.getUserName() != null) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword()));
            }
        }
        return credentialsProvider;
    }
}

