/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins.cloud.build;

import com.soasta.jenkins.cloud.CloudCommandBuilder;
import com.soasta.jenkins.cloud.CloudStatus;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class CloudCommandBaseBuild
extends Builder {
    private final String name;
    private final String cloudTestServerID;
    private final String url;
    private final int timeOut;

    public CloudCommandBaseBuild(String url, String cloudTestServerID, String name) {
        this.name = name;
        this.cloudTestServerID = cloudTestServerID;
        this.url = url;
        this.timeOut = -1;
    }

    public CloudCommandBaseBuild(String url, String cloudTestServerID, String name, int timeOut) {
        this.name = name;
        this.cloudTestServerID = cloudTestServerID;
        this.url = url;
        this.timeOut = timeOut == 0 ? this.getDefaultTimeout() : timeOut;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    public String getName() {
        return this.name;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String fileName;
        String command = this.getCommand();
        String resultsDir = "." + command;
        ArgumentListBuilder args = new CloudCommandBuilder().setBuild(build).setUrl(this.url).setListener(listener).setCloudTestServerID(this.cloudTestServerID).build();
        args.add(new String[]{"cmd=" + command, "wait=true", "format=xml"}).add("name=" + this.name);
        if (this.timeOut >= 0) {
            args.add("timeout=" + this.timeOut);
        }
        if ((fileName = this.name + ".xml").startsWith("/")) {
            fileName = fileName.substring(1);
        }
        fileName = resultsDir + File.separator + fileName;
        FilePath xml = new FilePath(build.getWorkspace(), fileName);
        xml.getParent().mkdirs();
        int exitCode = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout(xml.write()).stderr((OutputStream)listener.getLogger()).join();
        if (xml.length() == 0L) {
            return false;
        }
        try {
            return this.isSucessful(xml.readToString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public abstract String getCommand();

    public abstract CloudStatus getSuccessStatus();

    public abstract int getDefaultTimeout();

    private boolean isSucessful(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
        NodeList list = doc.getElementsByTagName("Status");
        if (list != null && list.getLength() > 0) {
            String successCriteria = this.getSuccessStatus().name();
            return list.item(0).getTextContent().equals(successCriteria);
        }
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

