/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins.cloud;

import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.ProxyChecker;
import com.soasta.jenkins.SCommandInstaller;
import hudson.AbortException;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.net.URL;
import jenkins.model.Jenkins;

public class CloudCommandBuilder {
    private String url;
    private String cloudTestServerID;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;

    public CloudTestServer getServer() {
        return CloudTestServer.getByID(this.cloudTestServerID);
    }

    public CloudCommandBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public CloudCommandBuilder setCloudTestServerID(String value) {
        this.cloudTestServerID = value;
        return this;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    public CloudCommandBuilder setBuild(AbstractBuild<?, ?> build) {
        this.build = build;
        return this;
    }

    public CloudCommandBuilder setListener(BuildListener listener) {
        this.listener = listener;
        return this;
    }

    public ArgumentListBuilder build() throws IOException, InterruptedException {
        String host;
        ProxyConfiguration proxyConfig;
        CloudTestServer s = this.getServer();
        if (s == null) {
            throw new AbortException("No TouchTest server is configured in the system configuration.");
        }
        FilePath scommand = new SCommandInstaller(s).scommand(this.build.getBuiltOn(), (TaskListener)this.listener);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add((Object)scommand).add("url=" + s.getUrl()).add("username=" + s.getUsername());
        if (s.getPassword() != null) {
            args.addMasked("password=" + s.getPassword());
        }
        if ((proxyConfig = Jenkins.getInstance().proxy) != null && proxyConfig.name != null && ProxyChecker.useProxy(host = new URL(s.getUrl()).getHost(), proxyConfig)) {
            args.add("httpproxyhost=" + proxyConfig.name).add("httpproxyport=" + proxyConfig.port);
            if (proxyConfig.getUserName() != null) {
                args.add("httpproxyusername=" + proxyConfig.getUserName()).addMasked("httpproxypassword=" + proxyConfig.getPassword());
            }
        }
        return args;
    }
}

