/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TransactionThreshold
extends AbstractDescribableImpl<TransactionThreshold> {
    private final String thresholdname;
    private final String thresholdvalue;
    private final String transactionname;
    private static final String PCTL_90TH = "90th Percentile";
    private static final String MIN_MSG_RSP = "Min Response Time";
    private static final String MAX_MSG_RSP = "Max Response Time";
    private static final String AVG_MSG_RSP = "Average Response Time";
    private static final String BYTES_SENT = "Total Bytes Sent";
    private static final String BYTES_RECEIVED = "Total Bytes Received";
    private static final String TRANSACTION_ERRORS = "Errors Per Transaction";
    private static final String MIN_TRANSACTION_COUNT = "Minimum Transaction Count";
    private static final String MIN_DURATION = "Min Duration";
    private static final String MAX_DURATION = "Max Duration";
    private static final String AVG_DURATION = "Average Duration";
    private static final char THRESHOLD_STR_SEPERATOR = '/';
    private static final String THRESHOLD_TO_SCOMMAND_FORMAT = "%s/%s/%s";

    @DataBoundConstructor
    public TransactionThreshold(String transactionname, String thresholdname, String thresholdvalue, String thresholdid) {
        this.thresholdname = thresholdname;
        this.thresholdvalue = thresholdvalue;
        this.transactionname = transactionname;
    }

    public String getTransactionname() {
        return this.transactionname;
    }

    public String getThresholdname() {
        return this.thresholdname;
    }

    public String getThresholdvalue() {
        return this.thresholdvalue;
    }

    public String toScommandString() {
        String WHITESPACE_PATTERN = "\\s";
        String trimSpaceThresholdName = this.thresholdname.replaceAll(WHITESPACE_PATTERN, "");
        String scommandFormatted = String.format(THRESHOLD_TO_SCOMMAND_FORMAT, this.transactionname, trimSpaceThresholdName, this.thresholdvalue);
        return scommandFormatted;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TransactionThreshold> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckTransactionname(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Paramater 'Transaction Name' is required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckThresholdvalue(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Parameter 'Threshold Value' is required");
            }
            double dNum = 0.0;
            try {
                dNum = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Value must be a positive number");
            }
            if (dNum < 0.0) {
                return FormValidation.error((String)"Value must be >= 0");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillThresholdnameItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add(TransactionThreshold.AVG_MSG_RSP, "AverageResponseTime");
            listBox.add(TransactionThreshold.PCTL_90TH, "90thPercentile");
            listBox.add(TransactionThreshold.MIN_MSG_RSP, "MinResponseTime");
            listBox.add(TransactionThreshold.MAX_MSG_RSP, "MaxResponseTime");
            listBox.add(TransactionThreshold.BYTES_SENT, "TotalBytesSent");
            listBox.add(TransactionThreshold.BYTES_RECEIVED, "TotalBytesReceived");
            listBox.add(TransactionThreshold.TRANSACTION_ERRORS, "ErrorsPerTransaction");
            listBox.add(TransactionThreshold.MIN_TRANSACTION_COUNT, "MinimumTransactionCount");
            listBox.add(TransactionThreshold.MIN_DURATION, "MinDuration");
            listBox.add(TransactionThreshold.MAX_DURATION, "MaxDuration");
            listBox.add(TransactionThreshold.AVG_DURATION, "AverageDuration");
            return listBox;
        }
    }
}

