/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.AbstractCloudTestBuilderDescriptor;
import com.soasta.jenkins.AbstractSCommandBuilder;
import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.JunitResultPublisher;
import com.soasta.jenkins.SCommandInstaller;
import com.soasta.jenkins.TransactionThreshold;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.util.ArgumentListBuilder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.QuotedStringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TestCompositionRunner
extends AbstractSCommandBuilder {
    private final String composition;
    private final boolean deleteOldResults;
    private final int maxDaysOfResults;
    private final String additionalOptions;
    private final List<TransactionThreshold> thresholds;
    private final boolean generatePlotCSV;
    private static final Logger LOGGER = Logger.getLogger(TestCompositionRunner.class.getName());

    @DataBoundConstructor
    public TestCompositionRunner(String url, String cloudTestServerID, String composition, DeleteOldResultsSettings deleteOldResults, String additionalOptions, List<TransactionThreshold> thresholds, boolean generatePlotCSV) {
        super(url, cloudTestServerID);
        this.composition = composition;
        this.deleteOldResults = deleteOldResults != null;
        this.maxDaysOfResults = deleteOldResults == null ? 0 : deleteOldResults.maxDaysOfResults;
        this.additionalOptions = additionalOptions;
        this.thresholds = thresholds;
        this.generatePlotCSV = generatePlotCSV;
    }

    public List<TransactionThreshold> getThresholds() {
        return this.thresholds;
    }

    public String getComposition() {
        return this.composition;
    }

    public boolean getDeleteOldResults() {
        return this.deleteOldResults;
    }

    public int getMaxDaysOfResults() {
        return this.maxDaysOfResults;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public boolean getGeneratePlotCSV() {
        return this.generatePlotCSV;
    }

    public Object readResolve() throws IOException {
        if (this.getCloudTestServerID() != null) {
            return this;
        }
        CloudTestServer s = CloudTestServer.getByURL(this.getUrl());
        LOGGER.info("Matched server URL " + this.getUrl() + " to ID: " + s.getId() + "; re-creating.");
        return new TestCompositionRunner(this.getUrl(), s.getId(), this.composition, this.deleteOldResults ? new DeleteOldResultsSettings(this.maxDaysOfResults) : null, this.additionalOptions, this.thresholds, this.generatePlotCSV);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String resultsDir = "." + ((Object)((Object)this)).getClass().getName();
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        String[] compositions = envs.expand(this.composition).split("[\r\n]+");
        String additionalOptionsExpanded = this.additionalOptions == null ? null : envs.expand(this.additionalOptions);
        String[] options = additionalOptionsExpanded == null ? null : new QuotedStringTokenizer(additionalOptionsExpanded).toArray();
        for (String composition : compositions) {
            String fileName;
            ArgumentListBuilder args = this.getSCommandArgs(build, listener);
            args.add(new String[]{"cmd=play", "wait", "format=junitxml"}).add("name=" + composition);
            if (this.thresholds != null) {
                this.displayTransactionThreholds(listener.getLogger());
                for (TransactionThreshold threshold : this.thresholds) {
                    args.add("validation=" + threshold.toScommandString());
                }
            }
            if ((fileName = composition + ".xml").startsWith("/")) {
                fileName = fileName.substring(1);
            }
            fileName = resultsDir + File.separator + fileName;
            FilePath xml = new FilePath(build.getWorkspace(), fileName);
            xml.getParent().mkdirs();
            if (options != null) {
                args.add(options);
            }
            if (this.generatePlotCSV) {
                args.add("outputthresholdcsvdir=" + build.getWorkspace());
            }
            int exitCode = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout(xml.write()).stderr((OutputStream)listener.getLogger()).join();
            if (xml.length() == 0L) {
                return false;
            }
            if (!this.deleteOldResults) continue;
            args = this.getSCommandArgs(build, listener);
            args.add(new String[]{"cmd=delete", "type=result"}).add("path=" + composition).add("maxage=" + this.maxDaysOfResults);
            launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout((TaskListener)listener).stderr((OutputStream)listener.getLogger()).join();
        }
        String resultsPattern = resultsDir + "/**/*.xml";
        JUnitResultArchiver archiver = new JUnitResultArchiver(resultsPattern, true, new DescribableList(Saveable.NOOP, Collections.singleton(new JunitResultPublisher(null))));
        return archiver.perform(build, launcher, listener);
    }

    private void displayTransactionThreholds(PrintStream jenkinsLogger) {
        String THRESHOLD_TABLE_FORMAT = "%-15s %-20s %7s";
        jenkinsLogger.println("~");
        jenkinsLogger.println("Custom Transaction Threholds:");
        for (TransactionThreshold threshold : this.thresholds) {
            String formattedString = String.format(THRESHOLD_TABLE_FORMAT, threshold.getTransactionname(), threshold.getThresholdname(), threshold.getThresholdvalue());
            jenkinsLogger.println(formattedString);
        }
        jenkinsLogger.println("~");
    }

    public static class DeleteOldResultsSettings {
        private final int maxDaysOfResults;

        @DataBoundConstructor
        public DeleteOldResultsSettings(int maxDaysOfResults) {
            this.maxDaysOfResults = maxDaysOfResults;
        }

        public int getMaxDaysOfResults() {
            return this.maxDaysOfResults;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCloudTestBuilderDescriptor {
        public String getDisplayName() {
            return "Play Composition(s)";
        }

        public FormValidation doCheckComposition(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Composition name is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxDaysOfResults(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Days to keep results is required.");
            }
            try {
                int maxDays = Integer.parseInt(value);
                if (maxDays <= 0) {
                    return FormValidation.error((String)"Value must be > 0.");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Value must be numeric.");
            }
        }

        public AutoCompletionCandidates doAutoCompleteComposition(@QueryParameter String cloudTestServerID) throws IOException, InterruptedException {
            CloudTestServer s = CloudTestServer.getByID(cloudTestServerID);
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add((Object)this.install(s)).add(new String[]{"list", "type=composition"}).add("url=" + s.getUrl()).add("username=" + s.getUsername());
            if (s.getPassword() != null) {
                args.addMasked("password=" + s.getPassword());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int exit = new Launcher.LocalLauncher(TaskListener.NULL).launch().cmds(args).stdout((OutputStream)out).join();
            if (exit == 0) {
                String line;
                BufferedReader r = new BufferedReader(new StringReader(out.toString()));
                AutoCompletionCandidates a = new AutoCompletionCandidates();
                while ((line = r.readLine()) != null) {
                    if (line.endsWith("object(s) found.")) continue;
                    a.add(line);
                }
                return a;
            }
            return new AutoCompletionCandidates();
        }

        private synchronized FilePath install(CloudTestServer s) throws IOException, InterruptedException {
            SCommandInstaller sCommandInstaller = new SCommandInstaller(s);
            return sCommandInstaller.scommand((Node)Jenkins.getInstance(), TaskListener.NULL);
        }
    }
}

