/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.CommonInstaller;
import com.soasta.jenkins.FakeInstallation;
import com.soasta.jenkins.Installers;
import com.soasta.jenkins.MakeAppTouchTestableInstaller;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.DownloadFromUrlInstaller;
import java.io.IOException;

public class SCommandInstaller
extends CommonInstaller {
    public SCommandInstaller(CloudTestServer server) throws IOException {
        super(server, Installers.SCOMMAND_INSTALLER);
    }

    public DownloadFromUrlInstaller.Installable getInstallable() throws IOException {
        DownloadFromUrlInstaller.Installable i = new DownloadFromUrlInstaller.Installable();
        i.url = this.getServer().getUrl() + this.getInstallerType().getInstallerDownloadPath();
        i.id = this.id;
        i.name = this.getBuildNumber().toString();
        return i;
    }

    public FilePath performInstallation(Node node, TaskListener log) throws IOException, InterruptedException {
        return super.performInstallation(new FakeInstallation(this.id), node, log);
    }

    public FilePath scommand(Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath scommandHome = this.performInstallation(node, log);
        String os = (String)node.toComputer().getSystemProperties().get("os.name");
        if (os != null && os.startsWith("Windows")) {
            return scommandHome.child("bin/scommand.bat");
        }
        return scommandHome.child("bin/scommand");
    }

    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<MakeAppTouchTestableInstaller> {
        public String getDisplayName() {
            return "Install CloudTest Command-Line Client";
        }
    }
}

