/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.AbstractCloudTestBuilderDescriptor;
import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.MakeAppTouchTestableInstaller;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MakeAppTouchTestable
extends Builder {
    private final String url;
    private final String cloudTestServerID;
    private final InputType inputType;
    private final String projectFile;
    private final String target;
    private final String launchURL;
    private final boolean backupModifiedFiles;
    private final String additionalOptions;
    private final String javaOptions;
    private final String DEFAULT_JAVA_OPTION = "-Xmx1024m";
    private static final Logger LOGGER = Logger.getLogger(MakeAppTouchTestable.class.getName());

    @DataBoundConstructor
    public MakeAppTouchTestable(String url, String cloudTestServerID, String inputType, String projectFile, String target, String launchURL, boolean backupModifiedFiles, String additionalOptions, String javaOptions) {
        this.url = url;
        this.cloudTestServerID = cloudTestServerID;
        this.inputType = InputType.getInputType(inputType);
        this.projectFile = projectFile;
        this.target = target;
        this.launchURL = launchURL;
        this.backupModifiedFiles = backupModifiedFiles;
        this.additionalOptions = additionalOptions;
        this.javaOptions = javaOptions;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLaunchURL() {
        return this.launchURL;
    }

    public boolean getBackupModifiedFiles() {
        return this.backupModifiedFiles;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public CloudTestServer getServer() {
        return CloudTestServer.getByID(this.cloudTestServerID);
    }

    public Object readResolve() throws IOException {
        if (this.cloudTestServerID != null) {
            return this;
        }
        CloudTestServer s = CloudTestServer.getByURL(this.getUrl());
        LOGGER.info("Matched server URL " + this.getUrl() + " to ID: " + s.getId() + "; re-creating.");
        return new MakeAppTouchTestable(this.url, s.getId(), this.inputType.getInputType(), this.projectFile, this.target, this.launchURL, this.backupModifiedFiles, this.additionalOptions, this.javaOptions);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        JDK java = build.getProject().getJDK();
        if (java != null) {
            args.add(java.getHome() + "/bin/java");
        } else {
            args.add("java");
        }
        CloudTestServer s = this.getServer();
        if (s == null) {
            throw new AbortException("No TouchTest server is configured in the system configuration.");
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        FilePath path = new MakeAppTouchTestableInstaller(s).performInstallation(build.getBuiltOn(), (TaskListener)listener);
        args.add("-Xmx1024m").add(new QuotedStringTokenizer(envs.expand(this.javaOptions)).toArray()).add("-jar").add((Object)path.child("MakeAppTouchTestable.jar")).add("-overwriteapp");
        if (s.getApitoken() != null) {
            args.add("-apitoken").add(s.getApitoken());
        } else {
            args.add("-url").add(s.getUrl()).add(new String[]{"-username", s.getUsername()});
            if (s.getPassword() != null) {
                args.add("-password").addMasked(s.getPassword().getPlainText());
            }
        }
        args.add(new String[]{this.inputType.getInputType(), envs.expand(this.projectFile)});
        if (this.target != null && !this.target.trim().isEmpty()) {
            args.add(new String[]{"-target", envs.expand(this.target)});
        }
        if (this.launchURL != null && !this.launchURL.trim().isEmpty()) {
            args.add(new String[]{"-launchURL", envs.expand(this.launchURL)});
        }
        if (!this.backupModifiedFiles) {
            args.add("-nobackup");
        }
        args.add(new QuotedStringTokenizer(envs.expand(this.additionalOptions)).toArray());
        int r = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
        return r == 0;
    }

    static enum InputType {
        APK("-apk"),
        APP("-appbundle"),
        IPA("-ipa"),
        PROJECT("-project");

        String inputType;

        private InputType(String inputType) {
            this.inputType = inputType;
        }

        private String getInputType() {
            return this.inputType;
        }

        private static InputType getInputType(String inputType) {
            return InputType.valueOf(inputType);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCloudTestBuilderDescriptor {
        public String getDisplayName() {
            return "Make App TouchTestable";
        }

        public FormValidation doCheckProjectFile(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Input file is required.");
            }
            return this.validateFileMask(project, value);
        }

        public ListBoxModel doFillInputTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Project", InputType.PROJECT.toString());
            items.add("APK", InputType.APK.toString());
            items.add("IPA", InputType.IPA.toString());
            items.add("iOS App Bundle", InputType.APP.toString());
            return items;
        }
    }
}

