/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.JunitResultAction;
import com.soasta.jenkins.Message;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class JunitResultActionConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(JunitResultAction.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        JunitResultAction resultAction = (JunitResultAction)((Object)value);
        writer.startNode("resultID");
        writer.setValue(resultAction.getResultID());
        writer.endNode();
        writer.startNode("url");
        writer.setValue(resultAction.getUrl());
        writer.endNode();
        writer.startNode("isPlayList");
        writer.setValue(Boolean.toString(resultAction.isPlayList()));
        writer.endNode();
        writer.startNode("exception");
        writer.setValue(resultAction.getExceptionMessage());
        writer.endNode();
        writer.startNode("messages");
        if (resultAction.getMessages() != null & resultAction.getErrorMessages().isEmpty()) {
            for (Message message : resultAction.getMessages()) {
                writer.startNode("message");
                context.convertAnother((Object)message);
                writer.endNode();
            }
        } else if (resultAction.getErrorMessages() != null && !resultAction.getErrorMessages().isEmpty()) {
            for (String error : resultAction.getErrorMessages()) {
                writer.startNode("message");
                context.convertAnother((Object)new Message(null, null, error));
                writer.endNode();
            }
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        JunitResultAction resultAction = new JunitResultAction();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if ("m__resultID".equals(nodeName) || "resultID".equals(nodeName)) {
                resultAction.setResultID(reader.getValue());
            } else if ("m__url".equals(nodeName) || "url".equals(nodeName)) {
                resultAction.setUrl(reader.getValue());
            } else if ("m__isPlayList".equals(nodeName) || "isPlayList".equals(nodeName)) {
                resultAction.setPlayList(Boolean.valueOf(reader.getValue()));
            } else if ("m__exception".equals(nodeName) || "exception".equals(nodeName)) {
                resultAction.setExceptionMessage(reader.getValue());
            } else if ("messages".equals(nodeName)) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("message".equals(reader.getNodeName())) {
                        Message message = (Message)context.convertAnother((Object)resultAction, Message.class);
                        resultAction.addMessage(message);
                    }
                    reader.moveUp();
                }
            } else if ("m__errorMessages".equals(nodeName)) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("string".equals(reader.getNodeName())) {
                        resultAction.addErrorMessage(reader.getValue());
                    }
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        return resultAction;
    }
}

