/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.AbstractCloudTestBuilderDescriptor;
import com.soasta.jenkins.AbstractSCommandBuilder;
import com.soasta.jenkins.CloudTestServer;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportFiles
extends AbstractSCommandBuilder {
    private final String files;
    private final String excludes;
    private final String mode;
    private final String additionalOptions;
    private static final Logger LOGGER = Logger.getLogger(ImportFiles.class.getName());

    @DataBoundConstructor
    public ImportFiles(String url, String cloudTestServerID, String files, String excludes, String mode, String additionalOptions) {
        super(url, cloudTestServerID);
        this.files = files.trim();
        this.excludes = Util.fixEmptyAndTrim((String)excludes);
        this.mode = mode;
        this.additionalOptions = additionalOptions;
    }

    public String getFiles() {
        return this.files;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getMode() {
        return this.mode;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public Object readResolve() throws IOException {
        if (this.getCloudTestServerID() != null) {
            return this;
        }
        CloudTestServer s = CloudTestServer.getByURL(this.getUrl());
        LOGGER.info("Matched server URL " + this.getUrl() + " to ID: " + s.getId() + "; re-creating.");
        return new ImportFiles(this.getUrl(), s.getId(), this.files, this.excludes, this.mode, this.additionalOptions);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = this.getSCommandArgs(build, listener);
        args.add("cmd=import");
        if (this.mode != null) {
            args.add("mode=" + this.mode);
        }
        String includes = ImportFiles.convertFileListToIncludePattern(this.files);
        FilePath[] filePaths = build.getWorkspace().list(includes, this.excludes);
        if (filePaths.length == 0) {
            listener.error("Import pattern did not match any files.");
            return true;
        }
        for (FilePath filePath : filePaths) {
            args.add("file=" + filePath.getRemote());
        }
        EnvVars envs = build.getEnvironment((TaskListener)listener);
        args.add(new QuotedStringTokenizer(envs.expand(this.additionalOptions)).toArray());
        int exitCode = launcher.launch().cmds(args).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
        return exitCode == 0;
    }

    private static String convertFileListToIncludePattern(String files) {
        return files.replaceAll("[\r\n]+", ",");
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCloudTestBuilderDescriptor {
        public String getDisplayName() {
            return "Import CloudTest Objects";
        }

        public FormValidation doCheckFiles(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            String includes = ImportFiles.convertFileListToIncludePattern(value);
            return this.validateFileMask(project, includes);
        }

        public ListBoxModel doFillModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Replace the existing object(s)", "overwrite");
            items.add("Fail the import", "error");
            items.add("Ignore", "skip");
            items.add("Generate a non-conflicting name", "rename");
            return items;
        }
    }
}

